(* Content-type: application/vnd.wolfram.mathematica *)

(*** Wolfram Notebook File ***)
(* http://www.wolfram.com/nb *)

(* CreatedBy='Mathematica 11.1' *)

(*CacheID: 234*)
(* Internal cache information:
NotebookFileLineBreakTest
NotebookFileLineBreakTest
NotebookDataPosition[       158,          7]
NotebookDataLength[    322868,       7086]
NotebookOptionsPosition[    317347,       6921]
NotebookOutlinePosition[    317690,       6936]
CellTagsIndexPosition[    317647,       6933]
WindowFrame->Normal*)

(* Beginning of Notebook Content *)
Notebook[{

Cell[CellGroupData[{
Cell["Header", "Section",
 CellChangeTimes->{{3.7138393590358686`*^9, 3.7138393720573626`*^9}}],

Cell[BoxData[
 RowBox[{"<<", "\"\<Utilities 3.0.m\>\""}]], "Input",
 CellChangeTimes->{{3.713842573831375*^9, 3.71384258143781*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"SetDirectory", "[", 
  RowBox[{"NotebookDirectory", "[", "]"}], "]"}]], "Input",
 CellChangeTimes->{{3.7114630194690485`*^9, 3.7114630370457473`*^9}, {
  3.7136114493260565`*^9, 3.713611455306723*^9}, {3.713841371998087*^9, 
  3.713841384687706*^9}},
 ExpressionUUID -> "0f94cef6-bf39-4eaf-9ce3-af87df9898fa"],

Cell[BoxData["\<\"D:\\\\Sergey\\\\Google Drive\\\\QO\\\\Data \
analysis\\\\2017-11-02 stress-engineered beams compilation 4mm and \
more\"\>"], "Output",
 CellChangeTimes->{3.7136143319080906`*^9, 3.7138413851876764`*^9, 
  3.714985565187928*^9, 3.717426723928727*^9, 3.7174276203330717`*^9, 
  3.718615921978943*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Functions", "Section",
 CellChangeTimes->{{3.7138393749524937`*^9, 3.7138393823208733`*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"QData", " ", 
   RowBox[{"format", ":", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Beam", " ", "number"}], ",", " ", 
      RowBox[{"f", " ", 
       RowBox[{"(", "MHz", ")"}]}], ",", " ", "Q"}], " ", 
     RowBox[{"(*", 
      RowBox[{"10", "^", "6"}], "*)"}], "}"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.7138396164142027`*^9, 3.713839623549715*^9}, {
   3.7138399600541773`*^9, 3.7138399722758465`*^9}, 3.7174276244218884`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{
     RowBox[{"avergares", " ", "Q"}], "-", 
     RowBox[{
     "factors", " ", "for", " ", "the", " ", "entries", " ", "having", " ", 
      "the", " ", "same", " ", "beam", " ", "number"}]}], ",", " ", 
    RowBox[{"by", " ", "default", " ", 
     RowBox[{"(", 
      RowBox[{
      "if", " ", "\[CapitalDelta]\[Nu]Same", " ", "is", " ", "unspecified"}], 
      ")"}], " ", "assumes", " ", "1", " ", "mode", " ", "per", " ", 
     "beam"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"AverageQFactors", "[", 
     RowBox[{"QData_", ",", 
      RowBox[{"\[CapitalDelta]\[Nu]Same_:", "Null"}]}], "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"NBeamList", ",", "QDataSel", ",", "sameF", ",", "ret"}], 
       "}"}], ",", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NBeamList", "=", 
        RowBox[{"DeleteDuplicates", "[", 
         RowBox[{"QData", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"sameF", "=", 
        RowBox[{"If", "[", 
         RowBox[{
          RowBox[{"\[CapitalDelta]\[Nu]Same", "===", "Null"}], ",", 
          RowBox[{"1", "&"}], ",", 
          RowBox[{
           RowBox[{"Round", "[", 
            RowBox[{
             RowBox[{"#", "[", 
              RowBox[{"[", "2", "]"}], "]"}], ",", 
             "\[CapitalDelta]\[Nu]Same"}], "]"}], "&"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"ret", "=", 
        RowBox[{"Table", "[", "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{
           RowBox[{"QDataSel", "=", 
            RowBox[{"SplitBy", "[", 
             RowBox[{
              RowBox[{"Select", "[", 
               RowBox[{"QData", ",", 
                RowBox[{
                 RowBox[{"(", 
                  RowBox[{
                   RowBox[{"#", "[", 
                    RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "NBeam"}], 
                  ")"}], "&"}]}], "]"}], ",", "sameF"}], "]"}]}], ";", 
           "\[IndentingNewLine]", 
           RowBox[{"Table", "[", 
            RowBox[{
             FractionBox[
              RowBox[{"Total", "[", "QDataSubSel", "]"}], 
              RowBox[{"Length", "[", "QDataSubSel", "]"}]], ",", 
             RowBox[{"{", 
              RowBox[{"QDataSubSel", ",", "QDataSel"}], "}"}]}], "]"}]}], ",", 
          RowBox[{"{", 
           RowBox[{"NBeam", ",", "NBeamList"}], "}"}]}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Sort", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{"ret", ",", "1"}], "]"}], ",", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ">", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.7138394118994555`*^9, 3.7138394622035103`*^9}, {
   3.713839572521016*^9, 3.713839657430279*^9}, {3.7138398488284435`*^9, 
   3.7138398544787216`*^9}, {3.7149880360399723`*^9, 3.714988045124079*^9}, {
   3.714988349425999*^9, 3.714988363858982*^9}, {3.714988396075266*^9, 
   3.7149884289101906`*^9}, {3.714988475231639*^9, 3.7149884760107965`*^9}, {
   3.7149885800447416`*^9, 3.7149886219571986`*^9}, {3.7149887237142353`*^9, 
   3.7149887889233894`*^9}, {3.7149889432471857`*^9, 3.71498899071564*^9}, {
   3.7149891837622538`*^9, 3.7149891860795827`*^9}, 3.714989222018216*^9, {
   3.714989375125098*^9, 3.7149893898453484`*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"find", " ", "medians", " ", "Q"}], "-", 
    RowBox[{
    "factors", " ", "for", " ", "the", " ", "entries", " ", "having", " ", 
     "the", " ", "same", " ", "beam", " ", "number"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"MedianQFactors", "[", "QData_", "]"}], ":=", 
    RowBox[{"Module", "[", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"NBeamList", ",", "QDataSel"}], "}"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"NBeamList", "=", 
        RowBox[{"DeleteDuplicates", "[", 
         RowBox[{"QData", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "1"}], "]"}], "]"}], "]"}]}], ";", 
       "\[IndentingNewLine]", 
       RowBox[{"Sort", "[", "\[IndentingNewLine]", 
        RowBox[{
         RowBox[{"Table", "[", "\[IndentingNewLine]", 
          RowBox[{
           RowBox[{
            RowBox[{"QDataSel", "=", 
             RowBox[{"Select", "[", 
              RowBox[{"QData", ",", 
               RowBox[{
                RowBox[{"(", 
                 RowBox[{
                  RowBox[{"#", "[", 
                   RowBox[{"[", "1", "]"}], "]"}], "\[Equal]", "NBeam"}], 
                 ")"}], "&"}]}], "]"}]}], ";", "\[IndentingNewLine]", 
            RowBox[{"{", 
             RowBox[{"NBeam", ",", 
              RowBox[{"Median", "[", 
               RowBox[{"QDataSel", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "2"}], "]"}], "]"}], "]"}], ",", 
              RowBox[{"Median", "[", 
               RowBox[{"QDataSel", "[", 
                RowBox[{"[", 
                 RowBox[{";;", ",", "3"}], "]"}], "]"}], "]"}]}], "}"}]}], 
           ",", 
           RowBox[{"{", 
            RowBox[{"NBeam", ",", "NBeamList"}], "}"}]}], "]"}], ",", 
         "\[IndentingNewLine]", 
         RowBox[{
          RowBox[{"(", 
           RowBox[{
            RowBox[{"#1", "[", 
             RowBox[{"[", "2", "]"}], "]"}], ">", 
            RowBox[{"#2", "[", 
             RowBox[{"[", "2", "]"}], "]"}]}], ")"}], "&"}]}], "]"}]}]}], 
     "\[IndentingNewLine]", "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.713614418039053*^9, 3.71361446917865*^9}, {
   3.713614570206264*^9, 3.713614615823589*^9}, {3.7136167275998454`*^9, 
   3.7136169078491454`*^9}, {3.7136170715553107`*^9, 
   3.7136171003605475`*^9}, {3.7136171511139073`*^9, 
   3.7136171521133647`*^9}, {3.7136171899822226`*^9, 
   3.7136173159088635`*^9}, {3.7136173515744715`*^9, 3.71361735225379*^9}, {
   3.71361741686734*^9, 3.7136174837632947`*^9}, {3.713839879024431*^9, 
   3.713839923011602*^9}, 3.7138400524704003`*^9}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"From", " ", "the", " ", "measurements", " ", "table"}], ",", " ", 
    RowBox[{
     RowBox[{
      RowBox[{
      "select", " ", "only", " ", "those", " ", "entries", " ", "that", " ", 
       "have", " ", "information", " ", "on", " ", "both", " ", "frequency", 
       " ", "and", " ", "quality", " ", 
       RowBox[{"factor", ".", " ", "Optionally"}], " ", "also", " ", 
       "selects", " ", "only", " ", "the", " ", "entries", " ", "with", " ", 
       "Q"}], ">", "QThreshold"}], ";", "\[IndentingNewLine]", 
     RowBox[{"QDataTable", " ", 
      RowBox[{"format", ":", " ", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"Beam", " ", "number"}], ",", " ", 
         RowBox[{"f", " ", 
          RowBox[{"(", "MHz", ")"}]}], ",", " ", 
         RowBox[{"Q", " ", 
          RowBox[{"(", 
           RowBox[{"\[Times]", 
            RowBox[{"10", "^", "6"}]}], ")"}]}], ",", " ", "Comment"}], 
        "}"}]}]}]}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"SelectFullQEntries", "[", 
     RowBox[{"QDataTable_", ",", 
      RowBox[{"OptionsPattern", "[", 
       RowBox[{"{", 
        RowBox[{"QThreshold", "\[Rule]", 
         RowBox[{"-", "1"}]}], "}"}], "]"}]}], "]"}], ":=", 
    RowBox[{"Select", "[", 
     RowBox[{
      RowBox[{"QDataTable", "[", 
       RowBox[{"[", 
        RowBox[{";;", ",", 
         RowBox[{"{", 
          RowBox[{"1", ",", "2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
      "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"(", 
        RowBox[{
         RowBox[{"NumberQ", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "1", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"NumberQ", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"NumberQ", "[", 
          RowBox[{"#", "[", 
           RowBox[{"[", "3", "]"}], "]"}], "]"}], "&&", 
         RowBox[{"(", 
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "3", "]"}], "]"}], ">", 
           RowBox[{"OptionValue", "[", "QThreshold", "]"}]}], ")"}]}], ")"}], 
       "&"}]}], "]"}]}], ";"}]}]], "Input",
 CellChangeTimes->{{3.713840655370558*^9, 3.713840909281171*^9}, {
  3.7138420635294714`*^9, 3.7138421078473034`*^9}, {3.7138421522599964`*^9, 
  3.713842154707021*^9}}]
}, Closed]],

Cell[CellGroupData[{

Cell["Data processing", "Section",
 CellChangeTimes->{{3.7138393848495145`*^9, 3.7138393934605274`*^9}}],

Cell[CellGroupData[{

Cell["Data loading", "Subsection",
 CellChangeTimes->{{3.713840009211445*^9, 3.7138400235676394`*^9}, {
  3.71384133834262*^9, 3.713841338796728*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"??", 
   RowBox[{"2017", "-", "09", "-", 
    RowBox[{"09", " ", "UQ31_stress", "_", "24", "cell_", "4", "mm"}]}]}], 
  "*)"}]], "Input",
 CellChangeTimes->{{3.7149857971487474`*^9, 3.714985802099864*^9}}],

Cell[BoxData[
 RowBox[{"(*", 
  RowBox[{"Q", " ", "factros", " ", "file", " ", 
   RowBox[{"format", ":", " ", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"Beam", " ", "number"}], ",", " ", 
      RowBox[{"f", " ", 
       RowBox[{"(", "MHz", ")"}]}], ",", " ", 
      RowBox[{"Q", " ", 
       RowBox[{"(", 
        RowBox[{"\[Times]", 
         RowBox[{"10", "^", "6"}]}], ")"}]}], ",", " ", "Comment"}], 
     "}"}]}]}], "*)"}]], "Input",
 CellChangeTimes->{{3.713839987796736*^9, 3.7138399964262624`*^9}, {
  3.7138407406729555`*^9, 3.713840741219912*^9}}],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"base", " ", "directory"}], ",", 
    RowBox[{
    "containing", " ", "the", " ", "folders", " ", "with", " ", "raw", " ", 
     "data"}]}], "*)"}], "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{
    "baseDirectory", "=", 
     "\"\<D:\\\\Sergey\\\\Google Drive\\\\QO\\\\Data\>\""}], ";"}], 
   "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{"(*", 
    RowBox[{
    "list", " ", "of", " ", "the", " ", "raw", " ", "data", " ", "folders"}], 
    "*)"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirList4mm", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "\"\<2017-09-15 UQ31_stress_14cell_4mm\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-19 UQ31_4mm_18unitcell\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-20 UQ31_4mm_20unitcell\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-20 UQ31_stress_28cell_4mm\>\"", 
       ",", "\[IndentingNewLine]", 
       "\"\<2017-09-19 UQ31_stress_30cell_4mm\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-09-05 UQ31_stress_34cell_4mm\>\"", 
       ",", "\[IndentingNewLine]", 
       "\"\<2017-09-08 UQ31_stress_36cell_4mm\>\"", ",", 
       "\[IndentingNewLine]", "\"\<2017-10-10 UQ35_stress_59cell_4mm\>\""}], 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirList7mm", "=", 
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
      "\"\<2017-09-27 UQ31_14cells_7mm\>\"", ",", "\[IndentingNewLine]", 
       "\"\<2017-09-28 UQ31_26unitcell_7mm\>\"", ",", "\[IndentingNewLine]", 
       "\"\<2017-09-27 UQ31_30cells_7mm\>\"", ",", "\[IndentingNewLine]", 
       "\"\<2017-09-28 UQ31_36unitcell_7mm\>\""}], "\[IndentingNewLine]", 
      "}"}]}], ";"}], "\[IndentingNewLine]", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirList6mm", "=", 
     RowBox[{
     "{", "\[IndentingNewLine]", "\"\<2017-09-28 UQ31_stress_36cell_6mm\>\"", 
      "\[IndentingNewLine]", "}"}]}], ";"}], "\[IndentingNewLine]", 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QFactorsFileName", "=", "\"\<Q factors.txt\>\""}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirListFull4mm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"baseDirectory", ",", "subDirName"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"subDirName", ",", "rawDataDirList4mm"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirListFull6mm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"baseDirectory", ",", "subDirName"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"subDirName", ",", "rawDataDirList6mm"}], "}"}]}], "]"}]}], 
    ";"}], "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"rawDataDirListFull7mm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"baseDirectory", ",", "subDirName"}], "}"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"subDirName", ",", "rawDataDirList7mm"}], "}"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.713840073972213*^9, 3.713840316990381*^9}, {
   3.7138403680776234`*^9, 3.7138403867983294`*^9}, {3.713840571187002*^9, 
   3.7138405849294653`*^9}, 3.7138572578721075`*^9, {3.7149858231068993`*^9, 
   3.7149858468745685`*^9}, {3.714986033801119*^9, 3.714986057800376*^9}, {
   3.7149861053968844`*^9, 3.7149861348968086`*^9}, {3.7149870583843327`*^9, 
   3.7149870615933065`*^9}, {3.717427207614753*^9, 3.717427210316352*^9}, {
   3.7186159362646456`*^9, 3.718615983658392*^9}, {3.7186163694995327`*^9, 
   3.7186165265340347`*^9}, {3.718617014130048*^9, 3.718617018006271*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"QDataTables4mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"dirName", ",", "QFactorsFileName"}], "}"}], "]"}], ",", 
       "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", "\"\<\\t\>\""}], ",", 
       RowBox[{"\"\<RepeatedSeparators\>\"", "\[Rule]", "False"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"dirName", ",", "rawDataDirListFull4mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QDataTables6mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"dirName", ",", "QFactorsFileName"}], "}"}], "]"}], ",", 
       "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", "\"\<\\t\>\""}], ",", 
       RowBox[{"\"\<RepeatedSeparators\>\"", "\[Rule]", "False"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"dirName", ",", "rawDataDirListFull6mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QDataTables7mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Import", "[", 
      RowBox[{
       RowBox[{"FileNameJoin", "[", 
        RowBox[{"{", 
         RowBox[{"dirName", ",", "QFactorsFileName"}], "}"}], "]"}], ",", 
       "\"\<Table\>\"", ",", 
       RowBox[{"\"\<FieldSeparators\>\"", "\[Rule]", "\"\<\\t\>\""}], ",", 
       RowBox[{"\"\<RepeatedSeparators\>\"", "\[Rule]", "False"}]}], "]"}], 
     ",", 
     RowBox[{"{", 
      RowBox[{"dirName", ",", "rawDataDirListFull7mm"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.71146319227089*^9, 3.7114632094854555`*^9}, {
  3.7114632869230704`*^9, 3.7114633010375557`*^9}, {3.7120328893790812`*^9, 
  3.712032906959397*^9}, {3.713840471041848*^9, 3.7138405335592337`*^9}, {
  3.7138410119614544`*^9, 3.713841040556593*^9}, {3.713841567353223*^9, 
  3.713841601935092*^9}, {3.713842001890781*^9, 3.713842014144478*^9}, {
  3.7138421209729443`*^9, 3.713842134067696*^9}, {3.718616606906966*^9, 
  3.718616635871957*^9}},
 ExpressionUUID -> "6e62ad71-6017-40eb-9159-26078f1fd163"]
}, Open  ]],

Cell[CellGroupData[{

Cell["Raw data overview", "Subsection",
 CellChangeTimes->{{3.7138421833400097`*^9, 3.713842205334895*^9}, {
  3.713842407108616*^9, 3.71384240874142*^9}, {3.7138431830120506`*^9, 
  3.713843184449935*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"\"\<Measurement folder name: \>\"", "~~", 
         RowBox[{"rawDataDirList4mm", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", "Bold", ",", "14"}], "]"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"QDataTables", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "//", "TableForm"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\<\\n\>\"", "]"}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "QDataTables4mm", "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.713841612449684*^9, 3.713841619187951*^9}, {
  3.713842191643379*^9, 3.7138421973147383`*^9}, {3.7138422284993057`*^9, 
  3.7138423868705378`*^9}, {3.718616716404298*^9, 3.718616721660946*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-15 UQ31_stress_14cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724242469*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam Number\"\>", "\<\"Freq\"\>", "\<\"Q\"\>"},
    {"5", "1.285908875`", "4.059533366`"},
    {"6", "1.275554125`", "18.11170926`"},
    {"7", "1.267679125`", "32.21658691`"},
    {"8", "1.25702775`", "101.659693`"},
    {"8", "1.25720775`", "79.61098161`"},
    {"8", "1.257292438`", "80.49530764`"},
    {"10", "1.2477265`", "100.5059535`"},
    {"10", "1.19228425`", "24.97258628`"},
    {"11", "1.245099`", "89.95447146`"},
    {"0", "1.204870625`", "45.8603842`"},
    {"66", "1.25881725`", "229.8252686`"},
    {"65", "1.276001125`", "13.57952192`"},
    {"64", "1.280660125`", "69.58187893`"},
    {"61", "1.311628625`", "350.833622`"},
    {"59", "1.324718125`", "158.6248802`"},
    {"58", "1.352406`", "300.5819181`"},
    {"57", "1.298095`", "112.2889617`"},
    {"53", "1.38674375`", "282.8322949`"},
    {"50", "1.408751`", "216.9133297`"},
    {"45", "1.43240975`", "148.3863602`"},
    {"44", "1.4488985`", "117.9017702`"},
    {"43", "1.46331675`", "116.4498576`"},
    {"39", "1.4937245`", "293.928391`"},
    {"38", "1.4871345`", "180.0768645`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724260479*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242624736`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_4mm_18unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242634745`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam Number\"\>", "\<\"Freq\"\>", "\<\"Q\"\>"},
    {"74", "1.322279875`", "0.904612514`"},
    {"74", "1.2430175`", "1.027511104`"},
    {"74", "1.615018125`", "11.75274205`"},
    {"73", "1.42762625`", "8.142504092`"},
    {"70", "1.6453775`", "52.78181817`"},
    {"70", "1.258452625`", "5.91614315`"},
    {"69", "1.3645725`", "8.025519366`"},
    {"69", "1.662068`", "20.06881546`"},
    {"68", "1.262829`", "3.924107246`"},
    {"75", "1.6311665`", "16.86993474`"},
    {"71", "1.65087325`", "18.31416897`"},
    {"69", "1.955058125`", "6.400160052`"},
    {"69", "1.66247475`", "18.20400848`"},
    {"68", "1.693850375`", "134.949893`"},
    {"64", "1.720007`", "160.1942938`"},
    {"63", "1.96045275`", "6.045876021`"},
    {"61", "1.765293`", "166.7919863`"},
    {"58", "1.79466675`", "21.52005642`"},
    {"57", "1.97174125`", "4.693834929`"},
    {"4", "1.6430535`", "49.56353861`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242654753`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242684784`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_4mm_20unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724269479*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam Number\"\>", "\<\"Freq[MHz]\"\>", "\<\"Q, 10^6\"\>"},
    {"1", "1.729831375`", "1.902857222`"},
    {"2", "1.734216`", "1.230670684`"},
    {"2", "1.73425975`", "1.448717295`"},
    {"3", "1.739776875`", "3.252826172`"},
    {"4", "1.745052125`", "1.64418912`"},
    {"4", "1.74513775`", "0.922386541`"},
    {"5", "1.7411475`", "2.780984736`"},
    {"6", "1.728`", "\<\"\"\>"},
    {"7", "1.74947625`", "0.985772066`"},
    {"8", "1.755`", "\<\"\"\>"},
    {"9", "1.746`", "\<\"\"\>"},
    {"10", "1.766`", "\<\"\"\>"},
    {"11", "\<\"\"\>", "\<\"\"\>"},
    {"12", "\<\"\"\>", "\<\"\"\>"},
    {"13", "\<\"\"\>", "\<\"\"\>"},
    {"14", "\<\"\"\>", "\<\"\"\>"},
    {"15", "1.74234375`", "4.673703172`"},
    {"15", "1.742428125`", "3.753468592`"},
    {"42", "1.773`", "\<\"\"\>"},
    {"58", "1.93299625`", "158.6905461`"},
    {"59", "1.922092`", "187.1345173`"},
    {"59", "1.922117`", "224.6315605`"},
    {"61", "1.901173625`", "220.7277657`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.71861672427149*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724274482*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_stress_28cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242764835`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"76", "2.576`", "\<\"\"\>", "\<\"can't drive (not a high-Q mode?)\"\>"},
    {"75", "2.62417618`", "153.116`", "\<\"\"\>"},
    {"75", "2.6257046`", "123.017`", "\<\"\"\>"},
    {"75", "2.62556006`", "124.871`", "\<\"\"\>"},
    {"75", "2.62542703`", "138.274`", "\<\"\"\>"},
    {"75", "2.62536216`", "140.582`", "\<\"\"\>"},
    {"74", "2.601`", "\<\"\"\>", "\<\"low Q, no ringdown\"\>"},
    {"73", "2.62367067`", "144.528`", "\<\"\"\>"},
    {"73", "2.62365065`", "125.959`", "\<\"\"\>"},
    {"73", "2.62354555`", "122.657`", "\<\"\"\>"},
    {"72", "2.64206817`", "37.685`", "\<\"\"\>"},
    {"72", "2.64205616`", "42.955`", "\<\"\"\>"},
    {"71", "2.65936036`", "162.09`", "\<\"\"\>"},
    {"71", "2.65939039`", "171.52`", "\<\"\"\>"},
    {"70", "2.6662012`", "110.894`", "\<\"\"\>"},
    {"70", "2.6662042`", "108.737`", "\<\"\"\>"},
    {"69", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"68", "2.72903303`", "225.802`", "\<\"\"\>"},
    {"68", "2.72917718`", "274.771`", "\<\"\"\>"},
    {"68", "2.72917117`", "231.135`", "\<\"\"\>"},
    {"68", "2.72915516`", "239.328`", "\<\"\"\>"},
    {"67", "2.71442543`", "252.488`", "\<\"\"\>"},
    {"67", "2.71441041`", "194.522`", "\<\"\"\>"},
    {"67", "2.7143003`", "227.891`", "\<\"\"\>"},
    {"66", "2.73866066`", "185.487`", "\<\"\"\>"},
    {"66", "2.7387007`", "207.185`", "\<\"\"\>"},
    {"66", "2.73863564`", "199.605`", "\<\"\"\>"},
    {"65", "2.74457558`", "76.78`", "\<\"\"\>"},
    {"65", "2.74473574`", "67.229`", "\<\"\"\>"},
    {"64", "2.75804905`", "189.527`", "\<\"\"\>"},
    {"64", "2.75790891`", "196.165`", "\<\"\"\>"},
    {"63", "2.75795296`", "76.755`", "\<\"\"\>"},
    {"63", "2.75812913`", "87.612`", "\<\"\"\>"},
    {"63", "2.75817318`", "80.298`", "\<\"\"\>"},
    {"62", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"61", "2.8114955`", "204.811`", "\<\"\"\>"},
    {"61", "2.81155556`", "213.645`", "\<\"\"\>"},
    {"60", "2.79506006`", "32.087`", "\<\"\"\>"},
    {"60", "2.79508008`", "35.206`", "\<\"\"\>"},
    {"59", "2.81245245`", 
     "207.098`", "\<\"non-linear decay at high amplitudes\"\>"},
    {"59", "2.81261662`", "159.535`", "\<\"\"\>"},
    {"59", "2.81264064`", "155.08`", "\<\"\"\>"},
    {"58", "2.83470371`", "16.289`", "\<\"\"\>"},
    {"57", "2.837`", "\<\"\"\>", "\<\"low Q, no ringdown\"\>"},
    {"56", "2.84530631`", "54.305`", "\<\"\"\>"},
    {"56", "2.84537838`", "60.882`", "\<\"\"\>"},
    {"55", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"54", "2.89208008`", "102.545`", "\<\"\"\>"},
    {"54", "2.89208408`", "102.211`", "\<\"\"\>"},
    {"53", "2.87248048`", "150.645`", "\<\"\"\>"},
    {"53", "2.87257257`", "157.176`", "\<\"\"\>"},
    {"52", "2.88528128`", "160.517`", "\<\"\"\>"},
    {"52", "2.88544845`", "153.721`", "\<\"\"\>"},
    {"51", "2.917`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"50", "2.90354555`", "113.773`", "\<\"\"\>"},
    {"49", "2.91673073`", "122.563`", "\<\"\"\>"},
    {"49", "2.91705606`", "138.005`", "\<\"\"\>"},
    {"48", "2.92575275`", "134.648`", "\<\"\"\>"},
    {"48", "2.92587288`", "131.559`", "\<\"\"\>"},
    {"47", "2.95498208`", "112.195`", "\<\"\"\>"},
    {"47", "2.95513804`", "103.617`", "\<\"\"\>"},
    {"46", "2.93945976`", "105.55`", "\<\"\"\>"},
    {"46", "2.93963664`", "129.724`", "\<\"\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242794857`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724284489*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_stress_30cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242864904`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"1", "\<\"\"\>", "\<\"\"\>", "\<\"Q bad by eye\"\>"},
    {"2", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"3", "2.70678078`", "3.288`", "\<\"\"\>"},
    {"4", "2.70179279`", "156.842`", "\<\"\"\>"},
    {"4", "2.70233333`", "151.79`", "\<\"\"\>"},
    {"5", "2.69736637`", "69.008`", "\<\"\"\>"},
    {"5", "2.69778679`", "97.65`", "\<\"\"\>"},
    {"5", "2.69788288`", "121.852`", "\<\"\"\>"},
    {"5", "2.69793694`", "95.896`", "\<\"\"\>"},
    {"6", "2.6820971`", "140.962`", "\<\"\"\>"},
    {"6", "2.6823934`", "146.896`", "\<\"\"\>"},
    {"7", "2.66282082`", "131.206`", "\<\"\"\>"},
    {"7", "2.66316116`", "142.955`", "\<\"\"\>"},
    {"8", "2.64802703`", "78.855`", "\<\"\"\>"},
    {"9", "2.64387287`", "105.736`", "\<\"\"\>"},
    {"9", "2.64431532`", "150.065`", "\<\"\"\>"},
    {"9", "2.64440641`", "171.349`", "\<\"\"\>"},
    {"9", "2.64446246`", "141.218`", "\<\"\"\>"},
    {"9", "2.64478479`", "136.263`", "\<\"\"\>"},
    {"10", "2.62908709`", "35.705`", "\<\"\"\>"},
    {"11", "2.62396096`", "88.669`", "\<\"\"\>"},
    {"11", "2.62402403`", "89.841`", "\<\"\"\>"},
    {"12", "2.61412813`", "26.665`", "\<\"\"\>"},
    {"13", "2.59`", "\<\"\"\>", "\<\"Q<10^7\"\>"},
    {"14", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"15", "2.57518118`", "10.627`", "\<\"\"\>"},
    {"16", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"17", "2.56037037`", "6.676`", "\<\"\"\>"},
    {"76", "2.78798719`", "51.861`", "\<\"\"\>"},
    {"75", "2.83377278`", "60.776`", "\<\"\"\>"},
    {"74", "2.81427628`", "58.893`", "\<\"\"\>"},
    {"73", "2.84071572`", "81.78`", "\<\"\"\>"},
    {"72", "2.86297147`", "20.593`", "\<\"\"\>"},
    {"71", "2.87934835`", "170.869`", "\<\"\"\>"},
    {"71", "2.87949049`", "163.585`", "\<\"\"\>"},
    {"70", "2.88515916`", "144.686`", "\<\"\"\>"},
    {"70", "2.8853934`", "141.628`", "\<\"\"\>"},
    {"69", "\<\"\"\>", "\<\"\"\>", "\<\"self-oscillating\"\>"},
    {"68", "2.94510511`", "126.374`", "\<\"\"\>"},
    {"68", "2.94547348`", "129.343`", "\<\"\"\>"},
    {"67", "2.92432032`", "192.804`", "\<\"\"\>"},
    {"67", "2.92471271`", "274.333`", "\<\"\"\>"},
    {"67", "2.92477277`", "267.012`", "\<\"\"\>"},
    {"66", "2.9405005`", "179.268`", "\<\"\"\>"},
    {"66", "2.94071071`", "196.394`", "\<\"\"\>"},
    {"65", "2.95878879`", "105.662`", "\<\"\"\>"},
    {"65", "2.959001`", "104.933`", "\<\"\"\>"},
    {"64", "2.96828128`", 
     "141.249`", "\<\"non-esponential decay at high amplitude\"\>"},
    {"64", "2.96851151`", "175.611`", "\<\"\"\>"},
    {"64", "2.96863263`", "184.617`", "\<\"\"\>"},
    {"63", "\<\"\"\>", "\<\"\"\>", "\<\"No beam?\"\>"},
    {"62", "2.98327027`", "154.327`", "\<\"\"\>"},
    {"62", "2.98346246`", "170.436`", "\<\"\"\>"},
    {"61", "\<\"\"\>", "\<\"\"\>", "\<\"No signal\"\>"},
    {"60", "\<\"\"\>", "\<\"\"\>", "\<\"self-excited\"\>"},
    {"59", "3.02271351`", "140.037`", "\<\"\"\>"},
    {"58", "3.06211712`", "56.309`", "\<\"\"\>"},
    {"57", "3.053`", "\<\"\"\>", "\<\"low Q\"\>"},
    {"54", "3.09784444`", "146.545`", "\<\"\"\>"},
    {"54", "3.09765315`", "151.855`", "\<\"\"\>"},
    {"53", "3.08267568`", "88.657`", "\<\"\"\>"},
    {"53", "3.08297177`", "120.474`", "\<\"\"\>"},
    {"52", "\<\"\"\>", "\<\"\"\>", "\<\"No signal\"\>"},
    {"51", "\<\"\"\>", "\<\"\"\>", "\<\"Self-excited\"\>"},
    {"50", "3.11907007`", "159.305`", "\<\"\"\>"},
    {"50", "3.11905806`", "153.276`", "\<\"\"\>"},
    {"49", "3.12567718`", "82.641`", "\<\"\"\>"},
    {"48", "3.13238439`", "88.941`", "\<\"\"\>"},
    {"48", "3.1326006`", "87.15`", "\<\"\"\>"},
    {"\<\"45-47\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"No signal\"\>"},
    {"44", "3.19`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"43", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"41", "3.19167528`", "46.963`", "\<\"\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724288492*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724293508*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-05 UQ31_stress_34cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724295497*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"1", "3.07648224`", "122.399`", "\<\"beatings in the signal\"\>"},
    {"1", "3.07668435`", "127.448`", "\<\"\"\>"},
    {"2", "3.0967844`", "\<\"\"\>", "\<\"Q<10^7\"\>"},
    {"3", "3.05852477`", 
     "102.559`", "\<\"self-excited, not a reliable number\"\>"},
    {"3", "3.05847224`", "118.38`", "\<\"\"\>"},
    {"4", "3.05015508`", "19.388`", "\<\"\"\>"},
    {"5", "3.04557129`", "108.84`", "\<\"\"\>"},
    {"5", "3.04615608`", "166.938`", "\<\"\"\>"},
    {"5", "3.04633017`", "96.192`", "\<\"\"\>"},
    {"6", "3.03304253`", "140.518`", "\<\"beating in the ringdown\"\>"},
    {"6", "3.0333887`", "162.838`", "\<\"\"\>"},
    {"7", "3.00349676`", "63.706`", "\<\"beating in the ringdown\"\>"},
    {"7", "3.00401901`", "69.328`", "\<\"\"\>"},
    {"8", "2.98173087`", "79.502`", "\<\"\"\>"},
    {"8", "2.98248324`", "93.139`", "\<\"\"\>"},
    {"9", "3.00073938`", "95.235`", "\<\"\"\>"},
    {"9", "3.00121962`", "132.489`", "\<\"\"\>"},
    {"10", "2.964`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"11", "2.95417409`", "85.651`", "\<\"\"\>"},
    {"11", "2.95453827`", "59.793`", "\<\"\"\>"},
    {"12", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"13", "2.94763332`", "47.641`", "\<\"strong beatings\"\>"},
    {"13", "2.94799525`", "64.999`", "\<\"\"\>"},
    {"14", "2.91750425`", "1.637`", "\<\"\"\>"},
    {"35", "3.666`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"36", "3.655`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"37", "3.654`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"38", "3.638`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"42", "2.92`", "\<\"\"\>", "\<\"not a localized mode, broad by eye\"\>"},
    {"63", "3.3812811`", "198.286`", "\<\"\"\>"},
    {"68", "3.36413334`", "219.057`", "\<\"\"\>"},
    {"68", "3.3644063`", "97.712`", "\<\"\"\>"},
    {"68", "3.36408931`", "294.66`", "\<\"looks reliable\"\>"},
    {"68", "3.36477251`", "266.777`", "\<\"looks reliable\"\>"},
    {"68", "3.36477196`", "204.598`", "\<\"looks reliable\"\>"},
    {"69", "3.31450028`", "152.935`", "\<\"\"\>"},
    {"69", "3.31475853`", "277.982`", "\<\"\"\>"},
    {"70", "3.29481251`", "202.893`", "\<\"\"\>"},
    {"70", "3.29459155`", "147.387`", "\<\"\"\>"},
    {"70", "3.29467564`", "133.23`", "\<\"\"\>"},
    {"71", "3.30655253`", "117.847`", "\<\"\"\>"},
    {"72", "3.29703317`", "86.229`", "\<\"?\"\>"},
    {"72", "3.2972016`", "214.92`", "\<\"more reliable\"\>"},
    {"72", "3.29706153`", "277.181`", "\<\"\"\>"},
    {"73", "3.26456778`", "184.194`", "\<\"\"\>"},
    {"73", "3.264599`", "182.595`", "\<\"\"\>"},
    {"73", "3.264599`", "147.563`", "\<\"\"\>"},
    {"74", "3.25686338`", 
     "333.885`", "\<\"Qf=10^15? almost too good to be true\"\>"},
    {"74", "3.25724637`", "336.901`", "\<\"\"\>"},
    {"74", "3.25767409`", "385.304`", "\<\"\"\>"},
    {"74", "3.25775593`", "256.311`", "\<\"\"\>"},
    {"74", "3.25813377`", "373.864`", "\<\"\"\>"},
    {"74", "3.25822201`", "140.723`", "\<\"\"\>"},
    {"74", "3.2581951`", "218.231`", "\<\"\"\>"},
    {"74", "3.2582052`", "461.257`", "\<\"\"\>"},
    {"74", "3.2582052`", "277.284`", "\<\"\"\>"},
    {"74", "3.25550117`", 
     "372.098`", "\<\"here and below for this beam measure at twice lower \
power (1 mW)\"\>"},
    {"74", "3.25460506`", "377.135`", "\<\"\"\>"},
    {"74", "3.25452702`", "246.34`", "\<\"\"\>"},
    {"74", "3.25442641`", "375.59`", "\<\"\"\>"},
    {"75", "3.28255828`", "152.806`", "\<\"\"\>"},
    {"75", "3.28265183`", "122.141`", "\<\"\"\>"},
    {"76", "3.22837669`", "254.479`", "\<\"\"\>"},
    {"76", "3.22895518`", "245.302`", "\<\"\"\>"},
    {"62", "3.39784094`", "128.161`", "\<\"poor s/n\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167242984986`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167243035035`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-08 UQ31_stress_36cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167243045044`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"1", "3.23097324`", "101.574`", "\<\"\"\>"},
    {"1", "3.23124218`", "103.857`", "\<\"\"\>"},
    {"2", "3.24195824`", "3.757`", "\<\"\"\>"},
    {"3", "3.20493543`", "114.281`", "\<\"\"\>"},
    {"3", "3.20511713`", "117.92`", "\<\"\"\>"},
    {"4", "3.19310232`", "109.304`", "\<\"\"\>"},
    {"5", "3.19416608`", "106.158`", "\<\"\"\>"},
    {"5", "3.19430886`", "87.995`", "\<\"\"\>"},
    {"6", "3.17984142`", "51.124`", "\<\"\"\>"},
    {"6", "3.18007204`", "32.126`", "\<\"\"\>"},
    {"7", "\<\"\"\>", "\<\"\"\>", "\<\"no beam\"\>"},
    {"8", "3.12518209`", "0.681`", "\<\"\"\>"},
    {"11", "3.0930036`", "23.769`", "\<\"\"\>"},
    {"41", "3.79635128`", "15.127`", "\<\"\"\>"},
    {"42", "3.79228005`", "12.67`", "\<\"\"\>"},
    {"45", "3.7697328`", "68.563`", "\<\"\"\>"},
    {"45", "3.76993048`", "31.465`", "\<\"\"\>"},
    {"47", "3.76464634`", "36.299`", "\<\"\"\>"},
    {"60", "3.6022072`", "139.027`", "\<\"\"\>"},
    {"60", "3.6022072`", "127.611`", "\<\"\"\>"},
    {"60", "3.6022072`", "130.215`", "\<\"\"\>"},
    {"61", "3.6260928`", "59.203`", "\<\"\"\>"},
    {"61", "3.62573524`", "71.788`", "\<\"\"\>"},
    {"72", "3.46792936`", "84.407`", "\<\"\"\>"},
    {"73", "3.4318809`", "86.962`", "\<\"\"\>"},
    {"74", "\<\"\"\>", "\<\"\"\>", "\<\"self-excited\"\>"},
    {"75", "3.4614937`", "244.017`", "\<\"easy to drive\"\>"},
    {"75", "3.46191452`", "143.165`", "\<\"\"\>"},
    {"75", "3.46191452`", "163.076`", "\<\"\"\>"},
    {"76", "3.40292742`", "151.861`", "\<\"\"\>"},
    {"76", "3.40309059`", "204.246`", "\<\"\"\>"},
    {"76", "3.40315416`", "183.08`", "\<\"\"\>"},
    {"71", "\<\"\"\>", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"70", "3.46510592`", "124.92`", "\<\"\"\>"},
    {"70", "3.46512973`", "233.763`", "\<\"\"\>"},
    {"70", "3.46521533`", "169.171`", "\<\"\"\>"},
    {"70", "3.46552374`", "343.413`", "\<\"probably not very reliable\"\>"},
    {"70", "3.46586918`", "149.411`", "\<\"\"\>"},
    {"70", "3.46608941`", "136.098`", "\<\"\"\>"},
    {"69", "3.496`", "\<\"\"\>", "\<\"Q not good by eye\"\>"},
    {"68", "3.54816817`", "8.532`", "\<\"\"\>"},
    {"67", "3.5050988`", "20.375`", "\<\"\"\>"},
    {"66", "3.5160946`", "129.203`", "\<\"\"\>"},
    {"66", "3.5160946`", "87.335`", "\<\"\"\>"},
    {"66", "3.51608359`", "109.303`", "\<\"\"\>"},
    {"65", "3.561`", "\<\"\"\>", "\<\"not good by eye\"\>"},
    {"64", "3.556`", "\<\"\"\>", "\<\"not measured, but below 10^7\"\>"},
    {"60", "\<\"\"\>", "\<\"\"\>", "\<\"self-excited, not measured\"\>"},
    {"59", "3.61560079`", "200.242`", "\<\"\"\>"},
    {"59", "3.61564344`", "132.433`", "\<\"good S/N\"\>"},
    {"59", "3.61570731`", "269.321`", "\<\"also good S/N\"\>"},
    {"59", "3.61569329`", "170.329`", "\<\"\"\>"},
    {"58", "3.667`", "\<\"\"\>", "\<\"can't drive\"\>"},
    {"57", "\<\"\"\>", "\<\"\"\>", "\<\"self-driven oscillations, not \
measured\"\>"},
    {"56", "3.647`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"55", "3.649`", "\<\"\"\>", "\<\"broad by eye\"\>"},
    {"54", "3.70240651`", "118", "\<\"\"\>"},
    {"54", "3.70263894`", "110.347`", "\<\"\"\>"},
    {"\<\"51-53\"\>", "\<\"\"\>", "\<\"\"\>", "\<\"no signal\"\>"},
    {"50", "3.712`", "\<\"\"\>", "\<\"can't drive\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167243075156`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167243115096`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-10-10 UQ35_stress_59cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.7186167243125095`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"\<\"Beam\"\>", "\<\"f (MHz)\"\>", "\<\"Q (*10^6)\"\>", \
"\<\"Comment\"\>"},
    {"50", "5.42609105`", "95.845`", "\<\"\"\>"},
    {"50", "5.4268047`", "112.552`", "\<\"\"\>"},
    {"50", "5.42635618`", "88.871`", "\<\"\"\>"},
    {"50", "5.42637319`", "95.179`", "\<\"\"\>"},
    {"48", "5.36033267`", "5.11`", "\<\"\"\>"},
    {"48", "5.36065734`", "3.424`", "\<\"\"\>"},
    {"45", "5.3605953`", "85.286`", "\<\"\"\>"},
    {"45", "5.36071346`", "93.454`", "\<\"\"\>"},
    {"44", "5.43661594`", "69.742`", "\<\"nice ringdowns on this beam\"\>"},
    {"44", "5.43660712`", "73.843`", "\<\"\"\>"},
    {"44", "5.43660859`", "67.156`", "\<\"\"\>"},
    {"42", 
     "5.4363262`", "\<\"\"\>", "\<\"(Q=182.838?)something strange, not real\"\
\>"},
    {"42", "5.43620707`", "104.255`", "\<\"nice ringdowns on this beam\"\>"},
    {"42", "5.43623796`", "106.503`", "\<\"\"\>"},
    {"42", "5.43627767`", "104.948`", "\<\"\"\>"},
    {"39", "5.59721808`", "1.824`", "\<\"\"\>"},
    {"38", "5.49748225`", "51.738`", "\<\"\"\>"},
    {"38", "5.49755357`", "56.1`", "\<\"\"\>"},
    {"34", "5.51871762`", "67.622`", "\<\"\"\>"},
    {"34", "5.51871887`", "66.244`", "\<\"\"\>"},
    {"34", "5.51879516`", "65.086`", "\<\"\"\>"},
    {"33", "5.58129115`", "72.218`", "\<\"\"\>"},
    {"33", "5.58133617`", "64.069`", "\<\"\"\>"},
    {"33", "5.58141721`", "64.471`", "\<\"\"\>"},
    {"32", "5.5741921`", "48.199`", "\<\"\"\>"},
    {"32", "5.57428214`", "46.212`", "\<\"\"\>"},
    {"31", "5.50634217`", "56.78`", "\<\"\"\>"},
    {"31", "5.50650726`", "59.413`", "\<\"\"\>"},
    {"26", "5.4574`", "\<\"\"\>", "\<\"no ringdown\"\>"},
    {"21", "5.72506603`", "46.016`", "\<\"\"\>"},
    {"21", "5.7252061`", "51.925`", "\<\"\"\>"},
    {"20", "5.83`", "\<\"\"\>", "\<\"no ringdown\"\>"},
    {"19", "5.877`", "\<\"\"\>", "\<\"no ringdown\"\>"},
    {"17", "5.93`", "\<\"\"\>", "\<\"may be a localized mode, but low Q\"\>"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724315511*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{{3.713842265082391*^9, 3.7138422793403263`*^9}, {
   3.7138423403436737`*^9, 3.7138423879720526`*^9}, 3.7138572659130597`*^9, 
   3.7149879756586227`*^9, 3.717427222755209*^9, 3.7174276205943327`*^9, 
   3.718616724318513*^9}]
}, Open  ]]
}, Open  ]]
}, Closed]],

Cell[CellGroupData[{

Cell["Experimental data plots", "Subsection",
 CellChangeTimes->{{3.713840009211445*^9, 3.7138400235676394`*^9}, {
  3.71384133834262*^9, 3.7138413614365807`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"QDataSets4mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"SelectFullQEntries", "[", 
      RowBox[{"QDataTable", ",", 
       RowBox[{"QThreshold", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataTable", ",", "QDataTables4mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QDataSets6mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"SelectFullQEntries", "[", 
      RowBox[{"QDataTable", ",", 
       RowBox[{"QThreshold", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataTable", ",", "QDataTables6mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QDataSets7mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"SelectFullQEntries", "[", 
      RowBox[{"QDataTable", ",", 
       RowBox[{"QThreshold", "\[Rule]", "5"}]}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataTable", ",", "QDataTables7mm"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.711463415351862*^9, 3.7114634817412925`*^9}, {
   3.7114635881643047`*^9, 3.7114636014523635`*^9}, {3.7120331386004105`*^9, 
   3.7120331508683605`*^9}, {3.712033217150267*^9, 3.712033264871915*^9}, {
   3.7136115375052404`*^9, 3.713611550039268*^9}, {3.7136115898213882`*^9, 
   3.7136116045559254`*^9}, 3.713614377122243*^9, 3.713840517918214*^9, {
   3.7138412179842997`*^9, 3.713841220516032*^9}, {3.7138412597421575`*^9, 
   3.71384128509925*^9}, {3.7138414239792156`*^9, 3.713841436051214*^9}, {
   3.7138414694403205`*^9, 3.71384147491203*^9}, {3.718616741029258*^9, 
   3.718616766002715*^9}},
 ExpressionUUID -> "7446f3f0-a65b-4b16-b0cd-2dcba7c5a083"],

Cell[BoxData[
 RowBox[{
  RowBox[{"(*", 
   RowBox[{
    RowBox[{"average", " ", "Q"}], "-", 
    RowBox[{"factors", " ", "over", " ", "beams"}]}], "*)"}], 
  "\[IndentingNewLine]", 
  RowBox[{
   RowBox[{
    RowBox[{"QDataSetsAvg4mm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"AverageQFactors", "[", 
        RowBox[{"QData", ",", "0.05"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"QData", ",", "QDataSets4mm"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QDataSetsAvg6mm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"AverageQFactors", "[", 
        RowBox[{"QData", ",", "0.05"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"QData", ",", "QDataSets6mm"}], "}"}]}], "]"}]}], ";"}], 
   "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{"QDataSetsAvg7mm", "=", 
     RowBox[{"Table", "[", 
      RowBox[{
       RowBox[{"AverageQFactors", "[", 
        RowBox[{"QData", ",", "0.05"}], "]"}], ",", 
       RowBox[{"{", 
        RowBox[{"QData", ",", "QDataSets7mm"}], "}"}]}], "]"}]}], 
    ";"}]}]}]], "Input",
 CellChangeTimes->{{3.713614418039053*^9, 3.71361446917865*^9}, {
   3.713614570206264*^9, 3.713614615823589*^9}, {3.7136167275998454`*^9, 
   3.7136169078491454`*^9}, {3.7136170715553107`*^9, 
   3.7136171003605475`*^9}, {3.713617493319521*^9, 3.7136175066499767`*^9}, {
   3.7138424297568493`*^9, 3.7138425195214615`*^9}, {3.7138429107577825`*^9, 
   3.7138429120137825`*^9}, {3.714988881529149*^9, 3.71498888533834*^9}, {
   3.7149894609487653`*^9, 3.7149894718636804`*^9}, 3.71499257088868*^9, 
   3.714992606283535*^9, {3.7186167846043835`*^9, 3.7186168076469517`*^9}}],

Cell[BoxData[{
 RowBox[{
  RowBox[{"QvsfListsExp4mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"QDataAvg", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataAvg", ",", "QDataSetsAvg4mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QfvsfListsExp4mm", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"QDataAvg", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"QDataAvg", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "2"}], "]"}], "]"}], " ", 
          RowBox[{
           RowBox[{"QDataAvg", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "3"}], "]"}], "]"}], "/", "100."}]}]}], "}"}],
        "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"QDataAvg", ",", "QDataSetsAvg4mm"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvsfListsExp6mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"QDataAvg", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataAvg", ",", "QDataSetsAvg6mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{
   RowBox[{"QfvsfListsExp6mm", "=", 
    RowBox[{"Table", "[", 
     RowBox[{
      RowBox[{"Transpose", "[", 
       RowBox[{"{", 
        RowBox[{
         RowBox[{"QDataAvg", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], ",", 
         RowBox[{
          RowBox[{"QDataAvg", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "2"}], "]"}], "]"}], " ", 
          RowBox[{
           RowBox[{"QDataAvg", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", "3"}], "]"}], "]"}], "/", "100."}]}]}], "}"}],
        "]"}], ",", 
      RowBox[{"{", 
       RowBox[{"QDataAvg", ",", "QDataSetsAvg6mm"}], "}"}]}], "]"}]}], ";"}], 
  "\[IndentingNewLine]"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvsfListsExp7mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"QDataAvg", "[", 
      RowBox[{"[", 
       RowBox[{";;", ",", 
        RowBox[{"{", 
         RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataAvg", ",", "QDataSetsAvg7mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QfvsfListsExp7mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"Transpose", "[", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"QDataAvg", "[", 
         RowBox[{"[", 
          RowBox[{";;", ",", "2"}], "]"}], "]"}], ",", 
        RowBox[{
         RowBox[{"QDataAvg", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", "2"}], "]"}], "]"}], " ", 
         RowBox[{
          RowBox[{"QDataAvg", "[", 
           RowBox[{"[", 
            RowBox[{";;", ",", "3"}], "]"}], "]"}], "/", "100."}]}]}], "}"}], 
      "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QDataAvg", ",", "QDataSetsAvg7mm"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.7138426999112034`*^9, 3.7138428131489077`*^9}, 
   3.713842855242285*^9, {3.7186168484196815`*^9, 3.718616890317622*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"QDataSetsAvg4mm", "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", ";;", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"blueColors", "[", 
       RowBox[{"[", 
        RowBox[{";;", "3"}], "]"}], "]"}], ",", "redColors"}], "]"}]}], ",", 
   "defaultPlotFrameOptions", ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<f [MHz]\>\"", ",", 
      "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"PlotLegends", "\[Rule]", "rawDataDirList4mm"}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<4mm beams\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{{3.7149895435857306`*^9, 3.7149895637774086`*^9}, {
  3.71499132740189*^9, 3.7149913629590316`*^9}, {3.7149914082337055`*^9, 
  3.714991460214899*^9}, {3.714991648276526*^9, 3.714991649059449*^9}, {
  3.718616918174158*^9, 3.71861692331929*^9}, {3.7186171340477076`*^9, 
  3.7186171413521724`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0., 0., 0.25]], 
        PointBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAARL5LqUvm9z/LLRN6vLsWQJENpItN
y/c/KygcZgbGFEAtBg/Tvmn3P2+FCMyjBxNAR5OLMbAu9z+7cDYJVBQTQGmL
a3wm6/Y/NgkWqdD/E0AWURN9Por2P4QvCxebhBVAHOviNhow9j+WAr2jVJQW
QHegTnl0o/U/x3MqWajSFkDusfShCzL1P3x1faEjRBRAjPUNTG789D9KGrKn
9XAXQDCeQUP/xPQ/GWj0oWHiEkANqaJ4lX30P6/UlANT+BBAHozYJ4Bq9D/C
pQk8Vt4EQENyMnGraPQ/RyP28CYsB0B8JvvnaUj0P42AlFmkxwtAIUCGjh0k
9D8C26qi0L8VQOLaSI9kHfQ/OiAVOxfgEUAFpP0PsPbzPwfWSLfccBJAUYTU
7ezr8z+59w92Sf8RQMmTpGsmR/M/AUBgCtWaDkD/klSmmBPzPwko474CvglA
sP6XjQ==
         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0.13999999999999999`, 0., 0.25]], 
        PointBox[{{1.96045275, 1.7993763901926663`}, {1.955058125, 
         1.8563229981779283`}, {1.79466675, 3.068985357037359}, {1.765293, 
         5.11674744500552}, {1.720007, 5.076387414773912}, {1.693850375, 
         4.9049035465774455`}, {1.66247475, 2.9016418159859723`}, {1.662068, 
         2.9991671406379723`}, {1.65087325, 2.9076750209179596`}, {1.6453775, 
         3.966166778568253}, {1.6430535, 3.9032554547366622`}, {1.6311665, 
         2.825533028144941}, {1.615018125, 2.4640865793220152`}, {1.42762625, 
         2.0970977607164825`}, {1.3645725, 2.0826263854266003`}, {1.258452625,
          1.7776847416484385`}}]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0.27999999999999997`, 0., 0.25]], 
        PointBox[{{1.93299625, 5.066956054869479}, {1.9221045, 
         5.327308235215739}, {1.901173625, 5.396930112780502}}]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[1., 0.4549019607843137, 0.2549019607843137]], 
        PointBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAjlNbh/ajB0CZLMBYnLkSQBYgwNgx
hAdAG2pkrgYSE0A/JJWMEGgHQDVeEJqDkBNAGoxLNMxVB0D4upkCl3oTQBeS
3RZ2OgdAbddGf9PvEkDMlPft+yIHQA8MZo3CgxJAoZ6hLDoVB0Bj18keXzoU
QOUjzi/v+gZAVotAgj4lFEByl+3YQsMGQOOYPQmxNhBAIWaCI3mtBkDsSklw
7FIGQJA+RKYkgAZAoQpHOU+iFECmwNkYAX4GQMIghrCqXxVAbW1lsk1cBkBn
pgrrlCAMQOwUaeqOEAZA2g2FhuiaEUBWPpFIVxAGQFjix2YtDBVAsdnTBg71
BUCdnCC/XhsRQEkXiIvJ6AVAytkw+TUkFUArxwFHRNUFQON4yvvg9xVAQs3V
Lwy3BUBvVvLF76kVQCIOyBRiVAVAE5k7q5LLEkBITbuYZkYFQHKORhihdxRA
Q2QFffEiBUDy3NLYJJMNQGopxTMNAQVAOVg85oyFE0ByVsAUUP4EQH/d+Mrx
HxRAYNrkri39BEB8siPDk4ATQB9LoN8=
         "]]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[0.9435294117647058, 0.276078431372549, 0.156078431372549]], 
        PointBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAxGmYDI2ICUDFmjBJfcsOQG7spzlY
DwlATBu7fFLpEUDHoI8JYwEJQO6ixj10qBFAOG5K3NfzCEBWE4wo9TQUQL78
LYUwyAhAKiu4ImoFFEDGqTF8n6kIQH23KMFomRJAqF+3Qjd/CECJ22hKmB8Q
QNoEtWuELghACKjYLoPEE0CMSk0v790HQC3l/HUbXBRA6k/q5G+/B0BKj2HW
zHkUQGCcMhbRqwdAdCQfeY2gEkBsRXrV848HQI9EUatYZxNAPEY/O1yGB0Ck
pc8VMvEUQFzhy7KVZQdArX7eIxoAFkBCMvS6CxUHQBEp5JcT2xNANPCCDA0J
B0APU5p0N3oUQJU/CJZd5wZAOPQDnxkzCECTENUpybkGQFaqhMC6nRFA9ygz
EJGrBkA+9PGExG0QQH0RREijgwZAVMZgIYpNEEBKvFU6zE0GQD+9/1Oqlg9A
/2/TPNOdBUCYI/xB8CcUQEQ9Emn6lAVAf4kwgvlCEkCOz2T/PHUFQPG9RHSV
4BNAxr1cOM5NBUBlhtV3qa4TQC0xpssoLwVAlLwC8m54EUCM0J2aqicFQPkI
MXj+yhNAIxbvz14IBUDaK2QHMpoMQKnL98bv/QRAfDv1Gkv3EUCmOk8CvOkE
QIq8u/hNRApAXf8ql/iZBEBnadgsPegCQB1h5nWjewRAEOYLd1Vg/j8AIdMS

         "]]}, {
        Hue[0.8503398874989481, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[
         0.8870588235294117, 0.09725490196078429, 0.05725490196078431]], 
        PointBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAArHoSO8cuC0DMeG4kxGkTQMqp+Brd
DAtAmgUL2qkoFUD6dkq7XOoKQMq2U7TwghVA9K3ma1yECkDK0jH6tn0VQDXZ
FtDRcwpAWngnO9oTE0BFH3RRdWAKQPBk/yLPCxVAPic8IIhbCkBek11RcFQU
QDVGZ3DGQgpABKvi8JexE0AqF9qf4B0KQAsemjfCkxRAnls7+BsOCkCwTlid
ghEXQCtGRM5O1AlAo1SyAYcVFkAyj9uz15wIQPGZv/6QTxNAGrhuEM53CEBW
WeU4p9ESQEmg4rS3ZghAOXbdrpy3B0C6tchNP14IQHvzzb/iRxNA2SFhjAZE
CECk+v82SBYUQMJqyTayBwhAOKYkUDLKEEBBu0OKAQIIQIZ/S3ug8BJAwCqT
8VrbB0DEj5yLD9URQBWvLn6FogdA7uMB/oUlEUCQDeanH5UHQL3H437LHxBA
Vq+Meg==
         "]]}, {
        Hue[0.08640786499873876, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[
         0.7788235294117646, 0.034509803921568646`, 0.034509803921568646`]], 
        PointBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAadJ9a+1eDkDq32KCWrsFQJsvQOyW
Vg5AVqE7fFtQBEDxzql9nSgOQGgzYH9lTA9A43J65v4dDkAXTR1//LsMQAyT
BDzEng1ATLrjqmzzEkAoELA13wENQBeakldZuhBA5gZ9yN/sDEAvPQH+bA0V
QGpTKwJS0QxA/JDmSTGKE0CH3Vb+pWIMQC0FwBeNJgFA1uUQSPQgDEAiKq/r
TcASQKL9WT1xCgxAg/+3200dCEBBTpC/Ub4LQObqLx8bvhFA4s+NPFK5C0Dk
0uxs6QsVQAaMPLK2sQtAO0WxidvYFEDpIir5fXQLQIsXQH6k3BFAXrAjJ3Y5
C0Czm86CC8QUQHhtwv9O2QlAtFQSUSGHEkBEXXvR5KMJQMXFNCqQBBNAVnbq
X8yNCUBvYxmyT00SQC10qTp5iwlA40x+zMrGEkBeXHAnjXAJQFQfrClh1A1A
OUjjq3i+CEAbzb/F2FgJQMDDkrU=
         "]]}, {
        Hue[0.3224758424985268, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[
         0.6188235294117647, 0.08784313725490198, 0.08784313725490198]], 
        PointBox[{{5.725136065, 3.8912180759949577`}, {5.581348176666666, 
         4.203487913925147}, {5.57423712, 3.854510411226679}, {
         5.518743883333333, 4.194451300931378}, {5.506424715, 
         4.06210542107945}, {5.49751791, 3.987482920438007}, {
         5.436610549999999, 4.252017602675652}, {5.4362409, 
         4.656199112100095}, {5.42640628, 4.586107135137818}, {5.36065438, 
         4.492785055393301}, {5.36033267, 
         1.631199404215613}}]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, 
     AxesOrigin -> {1.1214584403906251`, 1.324247676318211}, 
     PlotRange -> {{1.19228425, 5.725136065}, {1.3962486989114284`, 
      5.860312099690939}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.1214584403906251`, 1.324247676318211}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"4mm beams\"", TraditionalForm], 
     PlotRange -> {{1.19228425, 5.725136065}, {1.3962486989114284`, 
      5.860312099690939}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"2017-09-15 UQ31_stress_14cell_4mm\"", 
       "\"2017-09-19 UQ31_4mm_18unitcell\"", 
       "\"2017-09-20 UQ31_4mm_20unitcell\"", 
       "\"2017-09-20 UQ31_stress_28cell_4mm\"", 
       "\"2017-09-19 UQ31_stress_30cell_4mm\"", 
       "\"2017-09-05 UQ31_stress_34cell_4mm\"", 
       "\"2017-09-08 UQ31_stress_36cell_4mm\"", 
       "\"2017-10-10 UQ35_stress_59cell_4mm\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0., 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0., 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 
                    0.156078431372549]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 
                    0.156078431372549]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #6}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #7}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #8}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0., 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> CMYKColor[1., 0., 0., 0.5], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0., 0., 0.25]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0., 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0., 0., 0.25], Editable -> False, 
                    Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    CMYKColor[1., 0.1399999999999999, 0., 0.5], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0.13999999999999999, 0., 0.25]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    CMYKColor[1., 0.2799999999999998, 0., 0.5], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0.27999999999999997, 0., 0.25]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6666666666666667, 0.3032679738562092, 
                    0.16993464052287582`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1., 0.4549019607843137, 0.2549019607843137]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137], 
                    Editable -> False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6290196078431373, 0.18405228758169934`, 
                    0.10405228758169935`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.9435294117647058, 0.276078431372549, \
0.156078431372549]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549],
                     Editable -> False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5913725490196078, 0.06483660130718953, 
                    0.03816993464052287], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.8870588235294117, 0.09725490196078429, \
0.05725490196078431]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.8870588235294117, 0.09725490196078429, 
                    0.05725490196078431], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.5192156862745098, 0.02300653594771243, 
                    0.02300653594771243], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.7788235294117646, 0.034509803921568646, \
0.034509803921568646]"], Appearance -> None, BaseStyle -> {}, 
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.7788235294117646, 0.034509803921568646`, 
                    0.034509803921568646`], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.4125490196078431, 0.058562091503267986`, 
                    0.058562091503267986`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.6188235294117647, 0.08784313725490198, \
0.08784313725490198]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.6188235294117647, 0.08784313725490198, 
                    0.08784313725490198], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5, ",", #6, ",", #7, 
               ",", #8}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "False", ",", "False", ",", "False", ",", "False", ",", 
                 "False", ",", "False", ",", "False", ",", "False"}], "}"}]}],
            ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.714989550089841*^9, 3.714989564043166*^9}, 
   3.71499138078615*^9, 3.714991415426072*^9, 3.714991460599638*^9, 
   3.714991650526924*^9, 3.714992574095858*^9, 3.7149926088601646`*^9, 
   3.717427278134901*^9, 3.717427620949709*^9, 3.7186169255361395`*^9, 
   3.7186170300085444`*^9, 3.7186171420428514`*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{
    RowBox[{"Join", "[", 
     RowBox[{"QDataSetsAvg6mm", ",", "QDataSetsAvg7mm"}], "]"}], "[", 
    RowBox[{"[", 
     RowBox[{";;", ",", ";;", ",", 
      RowBox[{"{", 
       RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"Join", "[", 
     RowBox[{
      RowBox[{"blueColors", "[", 
       RowBox[{"[", 
        RowBox[{";;", "3"}], "]"}], "]"}], ",", "redColors"}], "]"}]}], ",", 
   "defaultPlotFrameOptions", ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<f [MHz]\>\"", ",", 
      "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"Join", "[", 
     RowBox[{"rawDataDirList6mm", ",", "rawDataDirList7mm"}], "]"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<6mm and 7mm beams\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{{3.7186169361472306`*^9, 3.7186169993723006`*^9}, {
  3.718617151425575*^9, 3.7186171607023945`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0., 0., 0.25]], 
        PointBox[{{2.53456937, 4.375354424905817}, {2.50762913, 
         3.700116086039924}, {2.408540606666666, 5.582169614575661}, {
         2.40495315, 4.231814023797547}, {2.366333335, 5.058907864019433}, {
         2.350633666666667, 5.233394771663586}, {2.31556126, 
         5.331918956573054}}]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0.13999999999999999`, 0., 0.25]], 
        PointBox[{{0.83, 5.321628537582378}, {0.829, 5.283716287712521}, {0.8,
          5.581812561246989}, {0.79, 5.661671455255786}, {0.76, 
         4.962278036209376}, {0.7, 5.281438211738784}, {0.681, 
         4.30567190969096}, {0.652, 3.9462891572957655`}}]}, {
        Hue[0.1421359549995791, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         AbsoluteThickness[1.6], 
         CMYKColor[1., 0.27999999999999997`, 0., 0.25]], 
        PointBox[{{1.329, 5.308537462991394}, {1.329, 5.308537462991394}}]}, {
        Hue[0.37820393249936934`, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         AbsoluteThickness[1.6], 
         RGBColor[1., 0.4549019607843137, 0.2549019607843137]], 
        PointBox[{{1.798, 5.487660050772875}, {1.781, 5.297507038320782}, {
         1.76375, 6.06770368421557}, {1.689, 5.652324254388423}}]}, {
        Hue[0.6142719099991583, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         AbsoluteThickness[1.6], 
         RGBColor[0.9435294117647058, 0.276078431372549, 0.156078431372549]], 
        PointBox[{{2.191, 3.1617127051348266`}, {2.185, 4.226446809104168}, {
         2.182, 4.4770867832229975`}}]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {0.62258485359375, 2.950794005040257}, 
     PlotRange -> {{0.652, 2.53456937}, {3.000268761852563, 
      6.06770368421557}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {0.62258485359375, 2.950794005040257}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"6mm and 7mm beams\"", TraditionalForm], 
     PlotRange -> {{0.652, 2.53456937}, {3.000268761852563, 
      6.06770368421557}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{
      "\"2017-09-28 UQ31_stress_36cell_6mm\"", 
       "\"2017-09-27 UQ31_14cells_7mm\"", 
       "\"2017-09-28 UQ31_26unitcell_7mm\"", 
       "\"2017-09-27 UQ31_30cells_7mm\"", 
       "\"2017-09-28 UQ31_36unitcell_7mm\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0., 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0., 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #3}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #4}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 
                    0.156078431372549]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 
                    0.156078431372549]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #5}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0., 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> CMYKColor[1., 0., 0., 0.5], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0., 0., 0.25]"], Appearance -> None, 
                    BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0., 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0., 0., 0.25], Editable -> False, 
                    Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    CMYKColor[1., 0.1399999999999999, 0., 0.5], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0.13999999999999999, 0., 0.25]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0.13999999999999999`, 0., 0.25], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    CMYKColor[1., 0.2799999999999998, 0., 0.5], FrameTicks -> 
                    None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "CMYKColor[1., 0.27999999999999997, 0., 0.25]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["CMYKColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    CMYKColor[1., 0.27999999999999997`, 0., 0.25], Editable -> 
                    False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6666666666666667, 0.3032679738562092, 
                    0.16993464052287582`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1., 0.4549019607843137, 0.2549019607843137]"], 
                    Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1., 0.4549019607843137, 0.2549019607843137], 
                    Editable -> False, Selectable -> False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.6290196078431373, 0.18405228758169934`, 
                    0.10405228758169935`], FrameTicks -> None, 
                    PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.9435294117647058, 0.276078431372549, \
0.156078431372549]"], Appearance -> None, BaseStyle -> {}, BaselinePosition -> 
                    Baseline, DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[
                    0.9435294117647058, 0.276078431372549, 0.156078431372549],
                     Editable -> False, Selectable -> False]}], "]"}]}], 
             "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2, ",", #3, ",", #4, ",", #5}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               
               RowBox[{
                "False", ",", "False", ",", "False", ",", "False", ",", 
                 "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{{3.7186169411656575`*^9, 3.718616969005836*^9}, 
   3.7186170002607574`*^9, 3.7186170315023785`*^9, 3.718617162869597*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"ScaleY", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{"QDataSetsAvg4mm", "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", ";;", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", "1"}], 
        "]"}], ",", 
       RowBox[{"Flatten", "[", 
        RowBox[{
         RowBox[{
          RowBox[{"Join", "[", 
           RowBox[{"QDataSetsAvg6mm", ",", "QDataSetsAvg7mm"}], "]"}], "[", 
          RowBox[{"[", 
           RowBox[{";;", ",", ";;", ",", 
            RowBox[{"{", 
             RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", "1"}], 
        "]"}]}], "}"}], ",", 
     SuperscriptBox["10", "6"]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0.9", " ", 
         SuperscriptBox["10", "7"]}], ",", 
        SuperscriptBox["10", "9"]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}], ",", "defaultPlotFrameOptions", 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<f [MHz]\>\"", ",", 
      "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<4mm beams\>\"", ",", "\"\<6-7 mm beams\>\""}], "}"}]}], ",", 
   RowBox[{"PlotLabel", "\[Rule]", "\"\<All beams, all data\>\""}]}], 
  "]"}]], "Input",
 CellChangeTimes->{
  3.7186171268356237`*^9, {3.7186171735849233`*^9, 3.7186171776686373`*^9}, {
   3.7186172362468653`*^9, 3.718617258204007*^9}, {3.7186173206214237`*^9, 
   3.718617365340135*^9}, {3.718617395766927*^9, 3.7186173962241473`*^9}, {
   3.7186175252283673`*^9, 3.7186175413980503`*^9}, {3.7186179297590218`*^9, 
   3.7186179449784546`*^9}, {3.718618010444477*^9, 3.718618026323944*^9}, 
   3.718618178383066*^9, {3.7186182247889175`*^9, 3.7186182269637733`*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1]], 
        PointBox[CompressedData["
1:eJwVlnk81dkfxiN3414pS6OmUWpsxb3fc7WQfB/LcJMlUZosRWkG2ZrQJkrU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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 0]], 
        PointBox[CompressedData["
1:eJxTTMoPSmViYGAQB2IQrbDfx++MG4vD+wTu9jsGRg6tx+ruzOdncdj9cYo0
Q4uhg+dR1g8bXJgdFgSrx51LNXZQ89krHGHL7HDo264yWR4jhw3Cr7Qd3jE5
LCzY++jmfSOHB2sl2STPMTnwRrnzt/IYO2itjfnt0sbkoJV+/sNeVWOH/kNf
NWL6X9lbJVj1SCsbO+zy5GHSbn9lryNo+S5N0thh1kwQeGnP/PXU921A+zwe
Vomsc39pz8K6daZGlbFD0A651teBL+yrdO3VZY8bOaSBwTN7cefiRRcljB1m
5Ak1Hzj11L41N/8Cq7yRQ/m++VL6d5/Y31GJ92M9bOhwV4WtcarzV/sY5cI5
B+WNHX4EP146+8gf+5xFJ6fN8TV2eHpB6fbPuj/2217N3/FOxtgBbJ3FH3vp
NtkQqUfGDguApqmw/bY3+rOJ9Ug5zP2MDqufHfbV/mXgUA107cMqRod5See3
7+UycgAalrWnhNFhv/fpFc+9jBwAduOgig==
         "]]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, 
     AxesOrigin -> {0, 16.03628778880872}, PlotRange -> 
     NCache[{{0, 6}, {16.012735135300492`, 
         Log[1000000000]}}, {{0, 6}, {16.012735135300492`, 
        20.72326583694641}}], PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 16.03628778880872}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"All beams, all data\"", TraditionalForm], PlotRange -> 
     NCache[{{0, 6}, {16.012735135300492`, 
         Log[1000000000]}}, {{0, 6}, {16.012735135300492`, 
        20.72326583694641}}], PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"4mm beams\"", "\"6-7 mm beams\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.718617129104388*^9, 3.7186171795133038`*^9, 3.7186173356856985`*^9, 
   3.718617366339418*^9, 3.7186175423909025`*^9, {3.7186179370659876`*^9, 
   3.7186179453326745`*^9}, 3.718618026999653*^9, 3.718618180048726*^9, 
   3.718618228558631*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"nMax", "=", "6"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QvsfMaxExp4mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"MaximalBy", "[", 
      RowBox[{"QvsfList", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "&"}], ",", "nMax"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QvsfList", ",", "QvsfListsExp4mm"}], "}"}]}], "]"}]}], 
  ";"}], "\[IndentingNewLine]", 
 RowBox[{
  RowBox[{"QfvsfMaxExp4mm", "=", 
   RowBox[{"Table", "[", 
    RowBox[{
     RowBox[{"MaximalBy", "[", 
      RowBox[{"QfvsfList", ",", 
       RowBox[{
        RowBox[{"#", "[", 
         RowBox[{"[", "2", "]"}], "]"}], "&"}], ",", "nMax"}], "]"}], ",", 
     RowBox[{"{", 
      RowBox[{"QfvsfList", ",", "QfvsfListsExp4mm"}], "}"}]}], "]"}]}], 
  ";"}]}], "Input",
 CellChangeTimes->{{3.713848023417819*^9, 3.713848139935424*^9}, {
  3.7138483054993057`*^9, 3.713848315854102*^9}, {3.714991512569135*^9, 
  3.714991627426943*^9}, {3.7174283655301714`*^9, 3.7174283656128774`*^9}, {
  3.7174284072283173`*^9, 3.7174284224657087`*^9}, {3.71861783785819*^9, 
  3.718617849554066*^9}},
 CellID->11232736],

Cell[BoxData[
 TemplateBox[{
  "MaximalBy","dstlms",
   "\"The requested number of elements \\!\\(\\*RowBox[{\\\"6\\\"}]\\) is \
greater than the number of elements \\!\\(\\*RowBox[{\\\"3\\\"}]\\). Only \\!\
\\(\\*RowBox[{\\\"3\\\"}]\\) elements will be returned.\"",2,89,5,
   29963937500937770048,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.7186178508391967`*^9}],

Cell[BoxData[
 TemplateBox[{
  "MaximalBy","dstlms",
   "\"The requested number of elements \\!\\(\\*RowBox[{\\\"6\\\"}]\\) is \
greater than the number of elements \\!\\(\\*RowBox[{\\\"3\\\"}]\\). Only \\!\
\\(\\*RowBox[{\\\"3\\\"}]\\) elements will be returned.\"",2,90,6,
   29963937500937770048,"Local"},
  "MessageTemplate"]], "Message", "MSG",
 CellChangeTimes->{3.718617850854206*^9}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"ScaleY", "[", 
    RowBox[{
     RowBox[{"{", 
      RowBox[{"Select", "[", 
       RowBox[{
        RowBox[{"Flatten", "[", 
         RowBox[{"QvsfMaxExp4mm", ",", "1"}], "]"}], ",", 
        RowBox[{
         RowBox[{
          RowBox[{"#", "[", 
           RowBox[{"[", "2", "]"}], "]"}], ">", "60"}], "&"}]}], "]"}], "}"}],
      ",", 
     SuperscriptBox["10", "6"]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0.9", " ", 
         SuperscriptBox["10", "7"]}], ",", 
        SuperscriptBox["10", "9"]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}], ",", "defaultPlotFrameOptions", 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<f [MHz]\>\"", ",", 
      "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<4mm beams\>\"", ",", "\"\<6-7 mm beams\>\""}], "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<Present manuscript plot:\\n4mm beams, post-selected 6 highst Q's per \
chip\>\""}]}], "]"}]], "Input",
 CellChangeTimes->{
  3.7186171268356237`*^9, {3.7186171735849233`*^9, 3.7186171776686373`*^9}, {
   3.7186172362468653`*^9, 3.718617258204007*^9}, {3.7186173206214237`*^9, 
   3.718617365340135*^9}, {3.718617395766927*^9, 3.7186173962241473`*^9}, {
   3.7186175252283673`*^9, 3.7186175413980503`*^9}, {3.718617866957368*^9, 
   3.718617869351042*^9}, {3.7186180448863916`*^9, 3.718618061589876*^9}, {
   3.71861813367107*^9, 3.718618207027895*^9}, {3.7186185111904726`*^9, 
   3.7186185316326785`*^9}, {3.7186185623044662`*^9, 3.718618596592047*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1]], 
        PointBox[CompressedData["
1:eJwBsQJO/SFib1JlAgAAACoAAAACAAAAjPUNTG789D9jhrS2Aq0zQHegTnl0
o/U/wpwSY2+FM0BEvkupS+b3P0PLTGu0fzNAHOviNhow9j92QLd12nUzQCFA
ho4dJPQ/kbZydblAM0AWURN9Por2P7HLihLsMTNAQblt36M+/D+FMOJ1qO4y
QNVBXg8mhfs/ekfwbFPkMkDPE8/ZAhr7P3WVCg9tuDJAx0j2CDVr/j9qMAWD
YjYzQDLp76XwwP4/XPa9xY8kM0B2ptB5je3+P9Du+VTp4TJAK8cBR0TVBUAJ
nrqLvU4zQELN1S8MtwVAbJVEPkE7M0CmwNkYAX4GQAGI6fivKDNASReIi8no
BUBDNhTL0hkzQFY+kUhXEAZAZvh5ptATM0CQPkSmJIAGQHjCGRtZ+TJAXOHL
spVlB0B7n7/Vy1AzQDxGPztchgdAOek70hENM0A08IIMDQkHQJSU7ilT7zJA
6k/q5G+/B0CjY2CCOO8yQIxKTS/v3QdAGzlHKsznMkA4bkrc1/MIQKYE65YC
3jJAnls7+BsOCkB8Ex70JZUzQCtGRM5O1AlA+ZQ0DSdWM0D6dkq7XOoKQIPt
3HmBMTNA9K3ma1yECkCDdFQLMzAzQMqp+BrdDAtAN8FKw+8aM0BFH3RRdWAK
QAzZhxW5EzNA5gZ9yN/sDEAcT0iMIBQzQOLPjTxSuQtAiTQDqL8TM0AGjDyy
trELQB9RNC/8BjNAXrAjJ3Y5C0C9pnstyAEzQGpTKwJS0QxAD6RBn1GzMkBE
XXvR5KMJQEExVVfpkTJA3rU677W+FUAoIgb3wXgyQNaiDdmjtBVAU17JatBm
MkBgCb1hT3EVQP3eGHbsTjJAsloF1ha/FUDtgYmGSREyQIF9ue9MUxZAZXB3
Fd0EMkC1qreYMRMWQAkqQtyMAjJAfjIcKQ==
         "]]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, 
     AxesOrigin -> {0, 16.03628778880872}, PlotRange -> 
     NCache[{{0, 6}, {16.012735135300492`, 
         Log[1000000000]}}, {{0, 6}, {16.012735135300492`, 
        20.72326583694641}}], PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 16.03628778880872}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"Present manuscript plot:\\n4mm beams, post-selected 6 highst \
Q's per chip\"", TraditionalForm], PlotRange -> 
     NCache[{{0, 6}, {16.012735135300492`, 
         Log[1000000000]}}, {{0, 6}, {16.012735135300492`, 
        20.72326583694641}}], PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"4mm beams\"", "\"6-7 mm beams\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{"Directive", "[", 
               RowBox[{
                 RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                 ",", 
                 RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                 InterpretationBox[
                  ButtonBox[
                   TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {},
                    BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                   ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                   Automatic, Method -> "Preemptive"], 
                  RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                  False]}], "]"}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"{", 
                 RowBox[{"False", ",", "Automatic"}], "}"}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", "False", "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.718617870110084*^9, 3.718618062961*^9, {3.718618136647797*^9, 
   3.71861816186269*^9}, 3.718618208193386*^9, {3.718618536335044*^9, 
   3.7186185971196003`*^9}}]
}, Open  ]],

Cell[CellGroupData[{

Cell[BoxData[{
 RowBox[{
  RowBox[{"thresh", "=", "70"}], ";"}], "\[IndentingNewLine]", 
 RowBox[{"ListLogPlot", "[", 
  RowBox[{
   RowBox[{"ScaleY", "[", "\[IndentingNewLine]", 
    RowBox[{
     RowBox[{"{", "\[IndentingNewLine]", 
      RowBox[{
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{"QDataSetsAvg4mm", "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", "1"}], 
          "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ">", "thresh"}], "&"}]}], "]"}], 
       ",", "\[IndentingNewLine]", 
       RowBox[{"Select", "[", 
        RowBox[{
         RowBox[{"Flatten", "[", 
          RowBox[{
           RowBox[{
            RowBox[{"Join", "[", 
             RowBox[{"QDataSetsAvg6mm", ",", "QDataSetsAvg7mm"}], "]"}], "[", 
            RowBox[{"[", 
             RowBox[{";;", ",", ";;", ",", 
              RowBox[{"{", 
               RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", "1"}], 
          "]"}], ",", 
         RowBox[{
          RowBox[{
           RowBox[{"#", "[", 
            RowBox[{"[", "2", "]"}], "]"}], ">", "thresh"}], "&"}]}], "]"}]}],
       "\[IndentingNewLine]", "}"}], ",", "\[IndentingNewLine]", 
     SuperscriptBox["10", "6"]}], "]"}], ",", 
   RowBox[{"PlotRange", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
      RowBox[{"{", 
       RowBox[{"0", ",", "6"}], "}"}], ",", 
      RowBox[{"{", 
       RowBox[{
        RowBox[{"0.9", " ", 
         SuperscriptBox["10", "7"]}], ",", 
        SuperscriptBox["10", "9"]}], "}"}]}], "}"}]}], ",", 
   RowBox[{"PlotStyle", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"Blue", ",", "Red"}], "}"}]}], ",", "defaultPlotFrameOptions", 
   ",", 
   RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
   RowBox[{"FrameLabel", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{
     "\"\<f [MHz]\>\"", ",", 
      "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], "}"}]}], 
   ",", 
   RowBox[{"PlotLegends", "\[Rule]", 
    RowBox[{"{", 
     RowBox[{"\"\<4mm beams\>\"", ",", "\"\<6-7 mm beams\>\""}], "}"}]}], ",", 
   RowBox[{
   "PlotLabel", "\[Rule]", 
    "\"\<All beams, post-selected Q>7\[Times]\!\(\*SuperscriptBox[\(10\), \(7\
\)]\)\>\""}]}], "]"}]}], "Input",
 CellChangeTimes->{{3.7186182737719355`*^9, 3.7186183298819885`*^9}, {
  3.718618369645404*^9, 3.7186183857083797`*^9}, {3.7186186140699434`*^9, 
  3.7186186396977*^9}}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[0, 0, 1]], 
        PointBox[CompressedData["
1:eJwVk3s81Wccx2N+535inENYEzVKcXh+VC7z+4g45ZZUutCS1iZiay7RdULF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         "]]}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.009166666666666668], 
         AbsoluteThickness[1.6], 
         RGBColor[1, 0, 0]], 
        PointBox[{{2.53456937, 18.190864982870092`}, {2.408540606666666, 
         19.397680172539935`}, {2.366333335, 18.87441842198371}, {
         2.350633666666667, 19.04890532962786}, {2.31556126, 
         19.14742951453733}, {0.83, 19.13713909554665}, {0.829, 
         19.099226845676796`}, {0.8, 19.39732311921126}, {0.79, 
         19.47718201322006}, {0.76, 18.77778859417365}, {0.7, 
         19.096948769703058`}, {0.681, 18.121182467655235`}, {1.329, 
         19.12404802095567}, {1.798, 19.303170608737148`}, {1.781, 
         19.113017596285054`}, {1.76375, 19.883214242179843`}, {1.689, 
         19.4678348123527}, {2.182, 
         18.29259734118727}}]}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {None, None}, DisplayFunction -> 
     Identity, DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, 
     AxesOrigin -> {0, 16.03628778880872}, PlotRange -> 
     NCache[{{0, 6}, {16.012735135300492`, 
         Log[1000000000]}}, {{0, 6}, {16.012735135300492`, 
        20.72326583694641}}], PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, AxesOrigin -> {0, 16.03628778880872}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {None, None}, GridLinesStyle -> Directive[
       GrayLevel[0.5, 0.4]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, PlotLabel -> 
     FormBox["\"All beams, post-selected \
Q>7\[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(7\\)]\\)\"", TraditionalForm],
      PlotRange -> NCache[{{0, 6}, {16.012735135300492`, 
         Log[1000000000]}}, {{0, 6}, {16.012735135300492`, 
        20.72326583694641}}], PlotRangeClipping -> True, 
     PlotRangePadding -> {{0, 0}, {0, 0}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"4mm beams\"", "\"6-7 mm beams\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[0, 0, 1]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.33000000000000007`], 
                    AbsoluteThickness[1.6], 
                    RGBColor[1, 0, 0]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0, 0, 1], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0., 0., 0.6666666666666666], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0, 0, 1]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0, 0, 1]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0, 0, 1], Editable -> False, Selectable -> 
                    False]}], "]"}], ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.009166666666666668`", "]"}], 
                   ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}], ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[1, 0, 0], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> RGBColor[0.6666666666666666, 0., 0.], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[1, 0, 0]"], Appearance -> None, BaseStyle -> {},
                     BaselinePosition -> Baseline, DefaultBaseStyle -> {}, 
                    ButtonFunction :> With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[1, 0, 0]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[1, 0, 0], Editable -> False, Selectable -> 
                    False]}], "]"}]}], "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "False"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Output",
 CellChangeTimes->{
  3.7186182484408646`*^9, 3.718618341043116*^9, {3.718618378604695*^9, 
   3.7186183865383153`*^9}, 3.718618640174816*^9}]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Q vs frequency", "Subsection",
 CellChangeTimes->{{3.7186178005249453`*^9, 3.718617811188348*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"\"\<Measurement folder name: \>\"", "~~", 
         RowBox[{"rawDataDirList", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", "Bold", ",", "14"}], "]"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\[IndentingNewLine]", 
      RowBox[{"ListLogPlot", "[", 
       RowBox[{
        RowBox[{"{", 
         RowBox[{
          RowBox[{"QDataSets", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", ";;", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}], ",", 
          RowBox[{"QDataSetsAvg", "[", 
           RowBox[{"[", 
            RowBox[{"i", ",", ";;", ",", 
             RowBox[{"{", 
              RowBox[{"2", ",", "3"}], "}"}]}], "]"}], "]"}]}], "}"}], ",", 
        RowBox[{"PlotRange", "\[Rule]", "Full"}], ",", 
        RowBox[{"Joined", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"False", ",", "True", ",", "True"}], "}"}]}], ",", 
        "defaultPlotFrameOptions", ",", "defaultPlotGridOptions", ",", 
        RowBox[{"ImageSize", "\[Rule]", "400"}], ",", 
        RowBox[{"FrameLabel", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{
          "\"\<f [MHz]\>\"", ",", 
           "\"\<Q, \[Times]\!\(\*SuperscriptBox[\(10\), \(6\)]\)\>\""}], 
          "}"}]}], ",", "\[IndentingNewLine]", 
        RowBox[{"PlotLegends", "\[Rule]", 
         RowBox[{"{", 
          RowBox[{"\"\<raw data\>\"", ",", "\"\<averaged\>\""}], "}"}]}]}], 
       "]"}], "\[IndentingNewLine]", "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\<\\n\>\"", "]"}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "QDataSets", "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{{3.7114635329953423`*^9, 3.7114636076370525`*^9}, 
   3.71146377283038*^9, 3.7120331652140512`*^9, {3.71361438616298*^9, 
   3.7136143939598866`*^9}, {3.713617107829365*^9, 3.713617122965357*^9}, {
   3.71361729242432*^9, 3.7136173335715065`*^9}, {3.7138425590735626`*^9, 
   3.713842566276472*^9}, {3.7138428853991795`*^9, 3.713842974078097*^9}, {
   3.713843010068701*^9, 3.7138431013958206`*^9}, {3.7149894868611107`*^9, 
   3.714989492405052*^9}},
 ExpressionUUID -> "cf72089c-9e61-45e8-b8a9-61308caccc19"],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-15 UQ31_stress_14cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427621002591*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAARL5LqUvm9z/LLRN6vLsWQJENpItN
y/c/KygcZgbGFEAtBg/Tvmn3P2+FCMyjBxNAR5OLMbAu9z+7cDYJVBQTQGmL
a3wm6/Y/NgkWqdD/E0AWURN9Por2P4QvCxebhBVAHOviNhow9j+WAr2jVJQW
QHegTnl0o/U/x3MqWajSFkDusfShCzL1P3x1faEjRBRAjPUNTG789D9KGrKn
9XAXQDCeQUP/xPQ/GWj0oWHiEkANqaJ4lX30P6/UlANT+BBAHozYJ4Bq9D/C
pQk8Vt4EQENyMnGraPQ/RyP28CYsB0B8JvvnaUj0P42AlFmkxwtAIUCGjh0k
9D8C26qi0L8VQOLaSI9kHfQ/OiAVOxfgEUAFpP0PsPbzPwfWSLfccBJAUYTU
7ezr8z+59w92Sf8RQMmTpGsmR/M/AUBgCtWaDkD/klSmmBPzPwko474CvglA
sP6XjQ==
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJwBgQF+/iFib1JlAgAAABcAAAACAAAAQ3Iycato9D9HI/bwJiwHQHwm++dp
SPQ/jYCUWaTHC0CloUYhyRz0P5HE/86MfBJApHGo34Ud9D+ZrC0lNIIRQF59
66zeHfQ/qDKvAoSNEUAFpP0PsPbzPwfWSLfccBJA/5JUppgT8z8JKOO+Ar4J
QFGE1O3s6/M/ufcPdkn/EUDJk6RrJkfzPwFAYArVmg5AIUCGjh0k9D8C26qi
0L8VQB6M2CeAavQ/wqUJPFbeBEANqaJ4lX30P6/UlANT+BBAjPUNTG789D9K
GrKn9XAXQO6x9KELMvU/fHV9oSNEFEB3oE55dKP1P8dzKlmo0hZAMJ5BQ//E
9D8ZaPShYeISQBzr4jYaMPY/lgK9o1SUFkAWURN9Por2P4QvCxebhBVAaYtr
fCbr9j82CRap0P8TQEeTizGwLvc/u3A2CVQUE0AtBg/Tvmn3P2+FCMyjBxNA
RL5LqUvm9z/LLRN6vLsWQJENpItNy/c/KygcZgbGFECxJKgz
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {1.18757424609375, 2.3725488632009717`},
      PlotRange -> {{1.19228425, 1.4937245}, {2.427910184415098, 
      5.860312099690939}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.18757424609375, 2.3725488632009717`}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {2.995732273553991, 3.912023005428146, 4.605170185988092, 
       5.298317366548036}}, GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1.19228425, 1.4937245}, {2.427910184415098, 
      5.860312099690939}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427621049493*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427621619727*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_4mm_18unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427621619727*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1.96045275, 1.7993763901926663`}, {1.955058125, 
         1.8563229981779283`}, {1.79466675, 3.068985357037359}, {1.765293, 
         5.11674744500552}, {1.720007, 5.076387414773912}, {1.693850375, 
         4.9049035465774455`}, {1.66247475, 2.9016418159859723`}, {1.662068, 
         2.9991671406379723`}, {1.65087325, 2.9076750209179596`}, {1.6453775, 
         3.966166778568253}, {1.6430535, 3.9032554547366622`}, {1.6311665, 
         2.825533028144941}, {1.615018125, 2.4640865793220152`}, {1.42762625, 
         2.0970977607164825`}, {1.3645725, 2.0826263854266003`}, {1.258452625,
          1.7776847416484385`}}]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[{{1.615018125, 2.4640865793220152`}, {1.42762625, 
         2.0970977607164825`}, {1.6453775, 3.966166778568253}, {1.258452625, 
         1.7776847416484385`}, {1.3645725, 2.0826263854266003`}, {1.662068, 
         2.9991671406379723`}, {1.6311665, 2.825533028144941}, {1.65087325, 
         2.9076750209179596`}, {1.955058125, 1.8563229981779283`}, {
         1.66247475, 2.9016418159859723`}, {1.693850375, 
         4.9049035465774455`}, {1.720007, 5.076387414773912}, {1.96045275, 
         1.7993763901926663`}, {1.765293, 5.11674744500552}, {1.79466675, 
         3.068985357037359}, {1.6430535, 
         3.9032554547366622`}}]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, 
     AxesOrigin -> {1.2474838730468754`, 1.5353334164047796`}, 
     PlotRange -> {{1.258452625, 1.96045275}, {1.5921812581286008`, 
      5.11674744500552}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.2474838730468754`, 1.5353334164047796`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {1.6094379124341003`, 2.302585092994046, 3.912023005428146, 
       4.605170185988092}}, GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1.258452625, 1.96045275}, {1.5921812581286008`, 
      5.11674744500552}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427621682226*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276219199553`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_4mm_20unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276219199553`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[{{1.93299625, 5.066956054869479}, {1.9221045, 
         5.327308235215739}, {1.901173625, 5.396930112780502}}]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[{{1.93299625, 5.066956054869479}, {1.922092, 
         5.231827702101076}, {1.922117, 5.414461551132426}, {1.901173625, 
         5.396930112780502}}]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {1.9006763964843754`, 5.04173388175362},
      PlotRange -> {{1.901173625, 1.93299625}, {5.047650193965982, 
      5.414461551132426}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {1.9006763964843754`, 5.04173388175362}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {5.075173815233827, 5.19295685089021, 5.298317366548036, 
       5.393627546352362}}, GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{1.901173625, 1.93299625}, {5.047650193965982, 
      5.414461551132426}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427621966816*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276222048597`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_stress_28cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276222048597`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBoQFe/iFib1JlAgAAABkAAAACAAAAjlNbh/ajB0CZLMBYnLkSQBYgwNgx
hAdAG2pkrgYSE0A/JJWMEGgHQDVeEJqDkBNAGoxLNMxVB0D4upkCl3oTQBeS
3RZ2OgdAbddGf9PvEkDMlPft+yIHQA8MZo3CgxJAoZ6hLDoVB0Bj18keXzoU
QOUjzi/v+gZAVotAgj4lFEByl+3YQsMGQOOYPQmxNhBAIWaCI3mtBkDsSklw
7FIGQJA+RKYkgAZAoQpHOU+iFECmwNkYAX4GQMIghrCqXxVAbW1lsk1cBkBn
pgrrlCAMQOwUaeqOEAZA2g2FhuiaEUBWPpFIVxAGQFjix2YtDBVAsdnTBg71
BUCdnCC/XhsRQEkXiIvJ6AVAytkw+TUkFUArxwFHRNUFQON4yvvg9xVAQs3V
Lwy3BUBvVvLF76kVQCIOyBRiVAVAE5k7q5LLEkBITbuYZkYFQHKORhihdxRA
Q2QFffEiBUDy3NLYJJMNQGopxTMNAQVAOVg85oyFE0ByVsAUUP4EQH/d+Mrx
HxRAYNrkri39BEB8siPDk4ATQB9LoN8=
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJwV0n9Qk3UcB/Dx43ke4sfG9jzPPPAHA9GLQplFtSOR9xkuNvIgcIgLCRDZ
OEBs6JQaUhwlBYiXWGd5piJ4cGHoZQsuFMHEg8NBhMAFhm6B5JLIgbAZ9O2P
z73v9d/7ffcJzipM2usuEAgU5P5PQ0oHl7jkidLxhZ7ZIA5FFy2577lRWOHy
MA3EsKAkrnPriFMz7/aFJLBQsssPfhdQSEr6YP5TMwv7iHqinfgNdXB+yW0W
PUupvm/+6wm5vS78ro2FySuhejNxd8emBc9UFqNH6SKK+HWn72sDm1mMnVk+
7wihIEzL+qLNyw9NYT47HxOXWdfIejkhjv1a1JquJB78wxCr5eBxy/3wPmJm
Pj8yvJbDKcOB+MwdFGQOxbnaIQmaGlfeyyLWWdbkH7ohwfP77LGiIQq7+y1z
bc08Esz6ES3x11O+B380SrGlpfPyTuLLIuf28z/zmFPOvJVA/HCx88T2aR5P
tnhfCjVTqNFZLKtlUnQuSu+sIjZPfDbwHM+Dj8hgrT9QUCrcmDAzj2Oaqke3
HlKQyitkKTYOL2w9O/0bcXybK/eMhkfopby+VuKtzeVjRRE8igXfetscFDZO
xRTLdosxfcXlrpij0DizLidgyB+6VZGUyZ9GRHK/McfJYVvG48qXiB8cvd3c
sJrH5Kjigoq45++mwN40Mb6Ze8etgfipVXg61iYGChsC2onLm6obBZVibLKo
tbMlNK4dCdIMqHisvKIf9j9CozqqTS46yENpmDDEpdHwy6MVe677oFb/52wS
8cT6k9J3S3zRu/8f8VQp6aNmE+VkD1oOh0Z/SOOUR0zOsopD/VeZP6mIxR1h
k0vhHIJzytYWN9Owq1X77Uk0svOyHRFdNLTd5dmLDhE+6jK2a4h3db28o7rQ
HzcCK+47QxgsTIz2F3wswYhQ53xGHLsh80tpmQQtz677DDtpRHcsdMeJOATG
jyUzLhrztrjIa1Ec0q3eWiHPAGXb/OISOdh2KZb3Ete/WFPlWsthxefjUmMU
g4JhZengjAT13998ZNQw6NYfivYi/3h8zy+m4BQGVSFWU+VVFvcO9ApndQye
zL89m3yaxdnBdG+5nkHrevl8TTmL7/4S1vfVMXgl9ebGT+5LUNB6MTfoAoPJ
gFaGOy5B5HjF+x7lDITGdI1bnQQLWU9fzSB2LF29s8HI4j/KIHDT
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {2.61836441734375, 2.5854171953837284`},
      PlotRange -> {{2.62354555, 2.95513804}, {2.6335207005916668`, 
      5.615938023483888}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {2.61836441734375, 2.5854171953837284`}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {2.995732273553991, 3.912023005428146, 4.605170185988092, 
       5.298317366548036}}, GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2.62354555, 2.95513804}, {2.6335207005916668`, 
      5.615938023483888}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276222517357`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427622482901*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_stress_30cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427622482901*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBEQLu/SFib1JlAgAAACAAAAACAAAAxGmYDI2ICUDFmjBJfcsOQG7spzlY
DwlATBu7fFLpEUDHoI8JYwEJQO6ixj10qBFAOG5K3NfzCEBWE4wo9TQUQL78
LYUwyAhAKiu4ImoFFEDGqTF8n6kIQH23KMFomRJAqF+3Qjd/CECJ22hKmB8Q
QNoEtWuELghACKjYLoPEE0CMSk0v790HQC3l/HUbXBRA6k/q5G+/B0BKj2HW
zHkUQGCcMhbRqwdAdCQfeY2gEkBsRXrV848HQI9EUatYZxNAPEY/O1yGB0Ck
pc8VMvEUQFzhy7KVZQdArX7eIxoAFkBCMvS6CxUHQBEp5JcT2xNANPCCDA0J
B0APU5p0N3oUQJU/CJZd5wZAOPQDnxkzCECTENUpybkGQFaqhMC6nRFA9ygz
EJGrBkA+9PGExG0QQH0RREijgwZAVMZgIYpNEEBKvFU6zE0GQD+9/1Oqlg9A
/2/TPNOdBUCYI/xB8CcUQEQ9Emn6lAVAf4kwgvlCEkCOz2T/PHUFQPG9RHSV
4BNAxr1cOM5NBUBlhtV3qa4TQC0xpssoLwVAlLwC8m54EUCM0J2aqicFQPkI
MXj+yhNAIxbvz14IBUDaK2QHMpoMQKnL98bv/QRAfDv1Gkv3EUCmOk8CvOkE
QIq8u/hNRApAXf8ql/iZBEBnadgsPegCQB1h5nWjewRAEOYLd1Vg/j8AIdMS

         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJwV0n9QkwUcx/Ex9ux5BiP37HkYZQaCBwKVCCM1E/cB1qV4E2mMbnFj6IIg
5UfIoh9HO3VwgJDLAW3eoSFG48fBdV6QORMQUUBd3EUNJup1KXWFkx+BpUBP
f3zve6//vnfvb+iBojdz+Dwe71Vu/t+/zt2ofr2JQNr+4TrLNhbrZia82acJ
mDLVPaIgFpW/XBmLrydgq5rycXsl+NO/IYFuIMBzvu96Sy3Fob2W08mcF9Ov
ypgtDOKv6Bf1nA3Rb2uvQ4p9J0VqbymBedGjgMRRBqPivo4aI4HzjQ2FH//N
IEZSxTOqCAy4tza7jjDQHYwt3riXwCFyoqh5gsHLsa2jkTEE6p38ucIPafiV
XhxrjSBQl5V779Y5KXq/0Y18tpHAUl9Prcafuz85qfYHzkFt5y5EWFn42KO8
Hs5j7pTz624ymJRYZsyRBO6HPz1c7WCwQeZ1ZVEEJl98h4w7JUZ8Sf7Ou8sC
/DY+oKl9RCM4vDKVtyKAYrPWurJMo3V7Kt/5hwA1zouPVUo/6Fajv3hsF+Dd
fPdLCb/z8cL+B8aWTwSQPPAv02SvKFKcmu03VEIoLq2q2xvXYClSLvm8Q4id
C7PmwQIJymnlrpZjQqQPZYfWqCSwSsajhi8IkdFu7vu+iUaDgmrUTQuxbcH3
zHNyCsEax/A0RULeOaB9w8Jiz3FdapyIRO9cWGyHgYWpRa++xZL413fatnCf
gaC/Kmx3IIkyoW83+yOD9bcblNYTJI6O3E4wZDLo7crKTbeQ8PC+7o8+zIAu
2BPAzyGRU1apWvAPRED08pCLc5rdBJlRhiXx80ov566c/E8NWhk2/JOyPryS
RFtmUuJ7/Sw0VnmGlbP02bkKd3AgcFJotHeQ4KflaoO4XqbWrF6qk0SJqbuU
1yRFc2FZot9lEuUV6QkZXJ+w1fzFo5xVX+1IS+1k8fTI1AcDnIVuW3fFXRbW
11pvOqdIKCLKZ/mRLMzaBUvoHRJbLvm80lXHYlLw7UHzJgqUw73p2CADh743
aauJQrUnL8UWIsFEVFH7gesU/Ee+U5HzDM66/tKvXKPg2XF59iPu31VxD6fS
2ijU259M5nH9FaHGtTOcf44JaS+IZjDmUPI98xSejCfHVexicUa+r+cnziVr
c+p9Q1lc+/KEyOAjwsOzQwmlDhrJeeLakDUiFHvIxO55Grbi5GkLZ+nIPfvk
HRqD+TZxXZUIV09t3l0++gz+Ay4wcNk=
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, 
     AxesOrigin -> {2.5505062307812496`, 1.6288221249909098`}, 
     PlotRange -> {{2.56037037, 3.19167528}, {1.6920843562917107`, 
      5.614342696941393}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {2.5505062307812496`, 1.6288221249909098`}, 
     DisplayFunction :> Identity, Frame -> {{True, True}, {True, True}}, 
     FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {1.6094379124341003`, 2.302585092994046, 3.912023005428146, 
       4.605170185988092}}, GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2.56037037, 3.19167528}, {1.6920843562917107`, 
      5.614342696941393}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276225433874`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276227208385`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-05 UQ31_stress_34cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276227208385`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBYQGe/iFib1JlAgAAABUAAAACAAAArHoSO8cuC0DMeG4kxGkTQMqp+Brd
DAtAmgUL2qkoFUD6dkq7XOoKQMq2U7TwghVA9K3ma1yECkDK0jH6tn0VQDXZ
FtDRcwpAWngnO9oTE0BFH3RRdWAKQPBk/yLPCxVAPic8IIhbCkBek11RcFQU
QDVGZ3DGQgpABKvi8JexE0AqF9qf4B0KQAsemjfCkxRAnls7+BsOCkCwTlid
ghEXQCtGRM5O1AlAo1SyAYcVFkAyj9uz15wIQPGZv/6QTxNAGrhuEM53CEBW
WeU4p9ESQEmg4rS3ZghAOXbdrpy3B0C6tchNP14IQHvzzb/iRxNA2SFhjAZE
CECk+v82SBYUQMJqyTayBwhAOKYkUDLKEEBBu0OKAQIIQIZ/S3ug8BJAwCqT
8VrbB0DEj5yLD9URQBWvLn6FogdA7uMB/oUlEUCQDeanH5UHQL3H437LHxBA
Vq+Meg==
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxFyWtMUwcAxXEkSm9voSu97W2VUBFf9RFKCFCwCT0gSCc2RsRKMBCcD9iy
tB1qLZMAAyZDRtVIt2mKIrJhw8pEtBUVJIAI2m6gWAQFNpROEfeKOpBt3fXL
9uHkn1/Okvd0qXt8fXx8Ypi9rTui4EqdhcDi339QWNdRMD1f951/DYFca0pT
wG4KaUrr/YcHCWT2bDx1/FM+xsMjUzoY53Ivy/LFFN6tnbjk2Esg1jDaZHGw
ML9w3qG0TAKqR1GndZ185D8JF5RnEaio+oCVZxTA3r4yY4KxY/6V+N/W87Fw
QO1qXE/AfmIowK+Xwsm8/Sk7EwnsDZXumssSQHM9bPMqFgGl5KxyroYH2cLd
EgVBoD7He6f6JQ/hf/9oN4+w0HgmmOMqDsTm9KS1IY9YUN08tuFZKB9dGT9/
XTqPwPKaZatbYvm4EVSrLfIlsPpavamnkkLjdL7fijoWtJEXdLQrEEUfPX71
hPGgf6knMJMHl1d2q6OaBUebK+HBUy7SgiyfFZpZeJUXUmm6yMNt68yiUX8O
Ti3gjFilQqQcNLe1PyMh18eQNpMQ575pGFZPkbjpbo34Zysf5bI3DQ3MnxSU
vkrVTmOTvnw44DkJcXOkrSCdxlLz5aNvfZ5yHOtQCWEwsFvFZSS0jj9br0kE
2DfZJallnGerDz1dQqM2Otnas4NETET+wzAIof+wvD+VsTNhRjY5Q8F2d9JT
yNi0AGcKjlOIGqb7B/aRyDCuVIxQFLYOyF+kZpP46eWGw7P3AsGtKlE0Mo7s
q5tdcUgInffsnZ2MvxivarIW0eDlbLPfDyYxtliTuXZUALnOIvAwVooq2uIG
/3elUM6WvKHQJUnaxeWSyA1JMMbHiaDZskU2xLjabXQakkVwWqa1jndI/Po0
9pcX/SJcP6nePsHYpyc58RMZDeXyJfrzPBK9Q3908y6KcPhAcYubsXrOGV3W
R2GTp+XLXsbuOG/L90eEuBuvfuxivM3r/GpNhfg/z04bKE4xjbmpiohEDonE
UfNRuU2E4e4L2Vo2CeuiWM1fV0XY06cxJDE+cjuredyPhq6k2c5jfC4qPrrX
LoK4NGvKlkCi0+RfNhYsQCpb/3qM8YAqhy6OofD6xgGp4x4ba9SdD6RSGtlO
/n7PIBvoE3Z/7kvj24/5ilthHDiN2mXd71P4F+VVbz8=
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {2.9405988259375, 2.734624402816405}, 
     PlotRange -> {{2.94763332, 3.39784094}, {2.788582037238229, 
      6.133955371391342}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {2.9405988259375, 2.734624402816405}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {2.995732273553991, 3.912023005428146, 4.605170185988092, 
       5.298317366548036, 6.214608098422191}}, GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{2.94763332, 3.39784094}, {2.788582037238229, 
      6.133955371391342}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276227832994`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276230051928`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-08 UQ31_stress_36cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.7174276230051928`*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[CompressedData["
1:eJwBcQGO/iFib1JlAgAAABYAAAACAAAAadJ9a+1eDkDq32KCWrsFQJsvQOyW
Vg5AVqE7fFtQBEDxzql9nSgOQGgzYH9lTA9A43J65v4dDkAXTR1//LsMQAyT
BDzEng1ATLrjqmzzEkAoELA13wENQBeakldZuhBA5gZ9yN/sDEAvPQH+bA0V
QGpTKwJS0QxA/JDmSTGKE0CH3Vb+pWIMQC0FwBeNJgFA1uUQSPQgDEAiKq/r
TcASQKL9WT1xCgxAg/+3200dCEBBTpC/Ub4LQObqLx8bvhFA4s+NPFK5C0Dk
0uxs6QsVQAaMPLK2sQtAO0WxidvYFEDpIir5fXQLQIsXQH6k3BFAXrAjJ3Y5
C0Czm86CC8QUQHhtwv9O2QlAtFQSUSGHEkBEXXvR5KMJQMXFNCqQBBNAVnbq
X8yNCUBvYxmyT00SQC10qTp5iwlA40x+zMrGEkBeXHAnjXAJQFQfrClh1A1A
OUjjq3i+CEAbzb/F2FgJQMDDkrU=
         "]]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.011000000000000001`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxF0n0s1HEcB/BzJX797o67353LsDxsJg9d7NYTtTdFWUSM0kk6UbL1gJRL
Rx67zMiclIbEYdpaNlGnU4zKstFGD07UleomYVaxqG//6I/P3nv9935vHwf5
qbB4NovF8iD3L3uPZ2Wav6HQkJWou3tBALfklVlq4h5vs5zkUgG8HPslrbcp
dMsUh+PmBIioWJcirKPQmnq3JEPIwCO1aWt6IQVDkPJFX68AFx7ZzmqKKCjH
GswMjQJ4Str7Z4jvPIVVxxc+Fr71tYSepiCdUW04mG6B7j7RzefEOzRBzPgT
Glt2G5rP68xh09/Z8/oAhcSXF5O+xfBgHJNnH9SaolKCyfJIHiJveWfIQlei
Zqe6OdGFhxUJLuLNXy3hF6ULGSResguRBl2jYUhWTCzZ8SAOtsv8reUgKdyN
HTbIwcg7mcb6EbPs8VFVR3T8f8/XZjtxFAyarRxnfNhczPqmHDGGWUJDbVdc
MuFi5JWzLHANH757Szr36WhMGCVrbXR8fHV0nb+YSqNQDGWdno85xUSl0z0a
Q0f8p9wWRSguO7aN1UIj7w17u+MIs+y3nVIoYoUIUOrZXlto+Fj7BeeKhWhl
uRUXEBvFtPtigAgOpXGGRuJP4yrbH8NC1FbqU1TtNGJn8zSqEAbKBfV3NfGM
yMFi46AInurqgS5ilb9xFzdfCHfl/eyjD2g0fSxP48vE6M75UGX9kPST1F3X
rxKCbmkQFRF3XeEM7WlgUDAauVQv58DD9LG4yNkEtYtR286s5iDnT9tIsJ05
vJ3qpT/sObiz1V7PS2aWHf7ULGPVez54SV9OThOfSMtPeEb+Q3s5zubxJAcV
3zfZtnmRPbG954aJu34FafcXMjg76jf3k7jx0JRGKrdCYETBjWli5/vtZVSR
EOlln4MLqrhoO62JWi9iUHPVwdWkmosKQXRM7oAAfwEC7ygf
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {3.0820137925, 1.8756303325866757`}, 
     PlotRange -> {{3.0930036, 3.79635128}, {1.9385399115055169`, 
      5.838933804473677}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {3.0820137925, 1.8756303325866757`}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {2.302585092994046, 3.912023005428146, 4.605170185988092}}, 
     GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{3.0930036, 3.79635128}, {1.9385399115055169`, 
      5.838933804473677}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.396], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.198], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.011000000000000001`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.71742762306771*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427623283493*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-10-10 UQ35_stress_59cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427623283493*^9}],

Cell[BoxData[
 TemplateBox[{GraphicsBox[{{}, {{{}, {}, {}, {
        Hue[0.9060679774997897, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.880722, 0.611041, 0.142051], 
         AbsoluteThickness[1.6]], 
        LineBox[{{5.725136065, 3.8912180759949577`}, {5.581348176666666, 
         4.203487913925147}, {5.57423712, 3.854510411226679}, {
         5.518743883333333, 4.194451300931378}, {5.506424715, 
         4.06210542107945}, {5.49751791, 3.987482920438007}, {
         5.436610549999999, 4.252017602675652}, {5.4362409, 
         4.656199112100095}, {5.42640628, 4.586107135137818}, {5.36065438, 
         4.492785055393301}, {5.36033267, 1.631199404215613}}]}}, {{}, {
        Hue[0.67, 0.6, 0.6], 
        Directive[
         PointSize[0.012833333333333334`], 
         RGBColor[0.368417, 0.506779, 0.709798], 
         AbsoluteThickness[1.6]], 
        PointBox[CompressedData["
1:eJxTTMoPSmViYGCQBmIQrVIZbBa4RdRhqdKcpzYOQg6nZCd68WwVdShcWvH3
2BMhh4UGz7ZNA8pLcf649eCToMOJw9k6s4H8+g+2PyUshRy8glR5fheIOsw6
+rQ7RfKXfUPspyf2haIOuvEdb7edEHRw3Np+Lw7Ivzx7bkycmpBD6s099hL7
RR20p8RMWPtLwEEr/dp7USD/nKeciIGpoEPn+ZogMSDfuYJx5p/LAg5pe94L
rN0n6jC7dZpu7DQhB4WnbzW3AvndP32nmq4RchBtuDRpP5BfJCj1VnWukMPq
mBV/sv+KOjgqFiWdncjvcH3hnXV1QP7swt7ak9ICDjqc5tu0hMUcRDo2Rgre
FnDwvy/JpQ3kvztnZ/LnqIDDEvFrnPZAvslLEf23mwUclC7u+mMbLOZgmrjx
QZqcoINA+4+TnkB+/WGGHWcWCzgEKVRyxAP5LHrCaSarBByqa3qYf3qLOVzs
iInayMDvEP6CfZ6Aj5jD5WUGlZWr+BxCPl7qr2MTc3DhvPtYXkPA4Wb35Wsr
gfwjC72md4UJOLRrztxa/kzMIWXufcGjC/kcwgs6c+cA+ctvr3tvMJPfAQC+
7rW5
         "]]}, {}, {}}}, {}, {}, {{}, {}}}, {
    DisplayFunction -> Identity, GridLines -> {Automatic, 
       Charting`ScaledTickValues[{Log, Exp}]}, DisplayFunction -> Identity, 
     DisplayFunction -> Identity, DisplayFunction -> Identity, 
     PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, AxesOrigin -> {5.354631522656251, 1.406764376830664}, 
     PlotRange -> {{5.36033267, 5.7252061}, {1.459409630167874, 
      4.723415337074912}}, PlotRangeClipping -> True, ImagePadding -> All, 
     DisplayFunction -> Identity, AspectRatio -> 
     NCache[GoldenRatio^(-1), 0.6180339887498948], Axes -> {True, True}, 
     AxesLabel -> {None, None}, 
     AxesOrigin -> {5.354631522656251, 1.406764376830664}, DisplayFunction :> 
     Identity, Frame -> {{True, True}, {True, True}}, FrameLabel -> {{
        FormBox[
        "\"Q, \[Times]\\!\\(\\*SuperscriptBox[\\(10\\), \\(6\\)]\\)\"", 
         TraditionalForm], None}, {
        FormBox["\"f [MHz]\"", TraditionalForm], None}}, FrameStyle -> 
     Directive[
       GrayLevel[0], 
       AbsoluteThickness[1]], FrameTicks -> {{
        Charting`ScaledTicks[{Log, Exp}], 
        Charting`ScaledFrameTicks[{Log, Exp}]}, {Automatic, Automatic}}, 
     GridLines -> {
      Automatic, {1.6094379124341003`, 2.302585092994046, 3.912023005428146, 
       4.605170185988092}}, GridLinesStyle -> Directive[
       GrayLevel[0.85], 
       AbsoluteThickness[1]], ImageSize -> 400, LabelStyle -> 
     Directive["Arial", 10], 
     Method -> {"CoordinatesToolOptions" -> {"DisplayFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& ), "CopiedValueFunction" -> ({
           (Part[{{Identity, Identity}, {Log, Exp}}, 1, 2][#]& )[
            Part[#, 1]], 
           (Part[{{Identity, Identity}, {Log, Exp}}, 2, 2][#]& )[
            Part[#, 2]]}& )}}, 
     PlotRange -> {{5.36033267, 5.7252061}, {1.459409630167874, 
      4.723415337074912}}, PlotRangeClipping -> True, PlotRangePadding -> {{
        Scaled[0.02], 
        Scaled[0.02]}, {
        Scaled[0.02], 
        Scaled[0.05]}}, Ticks -> {Automatic, 
       Charting`ScaledTicks[{Log, Exp}]}}],FormBox[
    FormBox[
     TemplateBox[{"\"raw data\"", "\"averaged\""}, "PointLegend", 
      DisplayFunction -> (FormBox[
        StyleBox[
         StyleBox[
          PaneBox[
           TagBox[
            GridBox[{{
               TagBox[
                GridBox[{{
                   GraphicsBox[{{}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.462], 
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    AbsoluteThickness[1.6]], 
                    PointBox[
                    NCache[{
                    Scaled[{
                    Rational[1, 2], 
                    Rational[1, 2]}]}, {
                    Scaled[{0.5, 0.5}]}]]}}}, AspectRatio -> Full, 
                    ImageSize -> {10, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #}, {
                   GraphicsBox[{{
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {
                    LineBox[{{0, 10}, {20, 10}}]}}, {
                    Directive[
                    EdgeForm[
                    Directive[
                    Opacity[0.3], 
                    GrayLevel[0]]], 
                    PointSize[0.231], 
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    AbsoluteThickness[1.6]], {}}}, AspectRatio -> Full, 
                    ImageSize -> {20, 10}, PlotRangePadding -> None, 
                    ImagePadding -> Automatic, 
                    BaselinePosition -> (Scaled[0.1] -> Baseline)], #2}}, 
                 GridBoxAlignment -> {
                  "Columns" -> {Center, Left}, "Rows" -> {{Baseline}}}, 
                 AutoDelete -> False, 
                 GridBoxDividers -> {
                  "Columns" -> {{False}}, "Rows" -> {{False}}}, 
                 GridBoxItemSize -> {"Columns" -> {{All}}, "Rows" -> {{All}}},
                  GridBoxSpacings -> {
                  "Columns" -> {{0.5}}, "Rows" -> {{0.8}}}], "Grid"]}}, 
             GridBoxAlignment -> {"Columns" -> {{Left}}, "Rows" -> {{Top}}}, 
             AutoDelete -> False, 
             GridBoxItemSize -> {
              "Columns" -> {{Automatic}}, "Rows" -> {{Automatic}}}, 
             GridBoxSpacings -> {"Columns" -> {{1}}, "Rows" -> {{0}}}], 
            "Grid"], Alignment -> Left, AppearanceElements -> None, 
           ImageMargins -> {{5, 5}, {5, 5}}, ImageSizeAction -> 
           "ResizeToFit"], LineIndent -> 0, StripOnInput -> False], {
          Directive["Arial", 10], FontFamily -> "Arial"}, Background -> 
         Automatic, StripOnInput -> False], TraditionalForm]& ), 
      InterpretationFunction :> (RowBox[{"PointLegend", "[", 
         RowBox[{
           RowBox[{"{", 
             RowBox[{
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.368417, 0.506779, 0.709798], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.24561133333333335`, 0.3378526666666667, 
                    0.4731986666666667], FrameTicks -> None, PlotRangePadding -> 
                    None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.368417, 0.506779, 0.709798]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.368417, 0.506779, 0.709798]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.368417, 0.506779, 0.709798], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}], 
               ",", 
               RowBox[{"Directive", "[", 
                 RowBox[{
                   RowBox[{"PointSize", "[", "0.012833333333333334`", "]"}], 
                   ",", 
                   InterpretationBox[
                    ButtonBox[
                    TooltipBox[
                    GraphicsBox[{{
                    GrayLevel[0], 
                    RectangleBox[{0, 0}]}, {
                    GrayLevel[0], 
                    RectangleBox[{1, -1}]}, {
                    RGBColor[0.880722, 0.611041, 0.142051], 
                    RectangleBox[{0, -1}, {2, 1}]}}, AspectRatio -> 1, Frame -> 
                    True, FrameStyle -> 
                    RGBColor[
                    0.587148, 0.40736066666666665`, 0.09470066666666668], 
                    FrameTicks -> None, PlotRangePadding -> None, ImageSize -> 
                    Dynamic[{
                    Automatic, 1.35 CurrentValue["FontCapHeight"]/
                    AbsoluteCurrentValue[Magnification]}]], 
                    "RGBColor[0.880722, 0.611041, 0.142051]"], Appearance -> 
                    None, BaseStyle -> {}, BaselinePosition -> Baseline, 
                    DefaultBaseStyle -> {}, ButtonFunction :> 
                    With[{Typeset`box$ = EvaluationBox[]}, 
                    If[
                    Not[
                    AbsoluteCurrentValue["Deployed"]], 
                    SelectionMove[Typeset`box$, All, Expression]; 
                    FrontEnd`Private`$ColorSelectorInitialAlpha = 1; 
                    FrontEnd`Private`$ColorSelectorInitialColor = 
                    RGBColor[0.880722, 0.611041, 0.142051]; 
                    FrontEnd`Private`$ColorSelectorUseMakeBoxes = True; 
                    MathLink`CallFrontEnd[
                    FrontEnd`AttachCell[Typeset`box$, 
                    FrontEndResource["RGBColorValueSelector"], {
                    0, {Left, Bottom}}, {Left, Top}, 
                    "ClosingActions" -> {
                    "SelectionDeparture", "ParentChanged", 
                    "EvaluatorQuit"}]]]], BaseStyle -> Inherited, Evaluator -> 
                    Automatic, Method -> "Preemptive"], 
                    RGBColor[0.880722, 0.611041, 0.142051], Editable -> False,
                     Selectable -> False], ",", 
                   RowBox[{"AbsoluteThickness", "[", "1.6`", "]"}]}], "]"}]}],
              "}"}], ",", 
           RowBox[{"{", 
             RowBox[{#, ",", #2}], "}"}], ",", 
           RowBox[{"LegendMarkers", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}], ",", 
                 RowBox[{"{", 
                   RowBox[{"False", ",", "Automatic"}], "}"}]}], "}"}]}], ",", 
           RowBox[{"Joined", "\[Rule]", 
             RowBox[{"{", 
               RowBox[{"False", ",", "True"}], "}"}]}], ",", 
           RowBox[{"LabelStyle", "\[Rule]", 
             RowBox[{"Directive", "[", 
               RowBox[{"\"Arial\"", ",", "10"}], "]"}]}], ",", 
           RowBox[{"LegendLayout", "\[Rule]", "\"Column\""}]}], "]"}]& ), 
      Editable -> True], TraditionalForm], TraditionalForm]},
  "Legended",
  DisplayFunction->(GridBox[{{
      TagBox[
       ItemBox[
        PaneBox[
         TagBox[#, "SkipImageSizeLevel"], Alignment -> {Center, Baseline}, 
         BaselinePosition -> Baseline], DefaultBaseStyle -> "Labeled"], 
       "SkipImageSizeLevel"], 
      ItemBox[#2, DefaultBaseStyle -> "LabeledLabel"]}}, 
    GridBoxAlignment -> {"Columns" -> {{Center}}, "Rows" -> {{Center}}}, 
    AutoDelete -> False, GridBoxItemSize -> Automatic, 
    BaselinePosition -> {1, 1}]& ),
  Editable->True,
  InterpretationFunction->(RowBox[{"Legended", "[", 
     RowBox[{#, ",", 
       RowBox[{"Placed", "[", 
         RowBox[{#2, ",", "After"}], "]"}]}], "]"}]& )]], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427623336733*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138430503238897`*^9, 3.7138431029877343`*^9, 
  3.7138572660093765`*^9, 3.7149894126384425`*^9, 3.714989494351406*^9, 
  3.714992577447723*^9, 3.7149926106754227`*^9, 3.717427292707486*^9, 
  3.717427623405763*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]],

Cell[CellGroupData[{

Cell["Averaged data overview", "Subsection",
 CellChangeTimes->{{3.7138421833400097`*^9, 3.713842205334895*^9}, {
  3.713842407108616*^9, 3.71384240874142*^9}, {3.7138431721900377`*^9, 
  3.713843176126772*^9}}],

Cell[CellGroupData[{

Cell[BoxData[
 RowBox[{
  RowBox[{"Do", "[", "\[IndentingNewLine]", 
   RowBox[{
    RowBox[{
     RowBox[{"Print", "[", 
      RowBox[{"Style", "[", 
       RowBox[{
        RowBox[{"\"\<Measurement folder name: \>\"", "~~", 
         RowBox[{"rawDataDirList", "[", 
          RowBox[{"[", "i", "]"}], "]"}]}], ",", "Bold", ",", "14"}], "]"}], 
      "]"}], ";", "\[IndentingNewLine]", 
     RowBox[{"Print", "[", 
      RowBox[{
       RowBox[{"QDataSetsAvg", "[", 
        RowBox[{"[", "i", "]"}], "]"}], "//", "TableForm"}], "]"}], ";", 
     "\[IndentingNewLine]", 
     RowBox[{"Print", "[", "\"\<\\n\>\"", "]"}], ";"}], ",", 
    "\[IndentingNewLine]", 
    RowBox[{"{", 
     RowBox[{"i", ",", 
      RowBox[{"Length", "[", "QDataTables", "]"}]}], "}"}]}], 
   "\[IndentingNewLine]", "]"}], ";"}]], "Input",
 CellChangeTimes->{3.7138432111634464`*^9}],

Cell[CellGroupData[{

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-15 UQ31_stress_14cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"39", "1.4937245`", "293.928391`"},
    {"38", "1.4871345`", "180.0768645`"},
    {"43", "1.46331675`", "116.4498576`"},
    {"44", "1.4488985`", "117.9017702`"},
    {"45", "1.43240975`", "148.3863602`"},
    {"50", "1.408751`", "216.9133297`"},
    {"53", "1.38674375`", "282.8322949`"},
    {"58", "1.352406`", "300.5819181`"},
    {"59", "1.324718125`", "158.6248802`"},
    {"61", "1.311628625`", "350.833622`"},
    {"57", "1.298095`", "112.2889617`"},
    {"64", "1.280660125`", "69.58187893`"},
    {"65", "1.276001125`", "13.57952192`"},
    {"6", "1.275554125`", "18.11170926`"},
    {"7", "1.267679125`", "32.21658691`"},
    {"66", "1.25881725`", "229.8252686`"},
    {"8", "1.2571759793333332`", "87.25532741666666`"},
    {"10", "1.2477265`", "100.5059535`"},
    {"11", "1.245099`", "89.95447146`"},
    {"0", "1.204870625`", "45.8603842`"},
    {"10", "1.19228425`", "24.97258628`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_4mm_18unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"63", "1.96045275`", "6.045876021`"},
    {"69", "1.955058125`", "6.400160052`"},
    {"58", "1.79466675`", "21.52005642`"},
    {"61", "1.765293`", "166.7919863`"},
    {"64", "1.720007`", "160.1942938`"},
    {"68", "1.693850375`", "134.949893`"},
    {"69", "1.66247475`", "18.20400848`"},
    {"69", "1.662068`", "20.06881546`"},
    {"71", "1.65087325`", "18.31416897`"},
    {"70", "1.6453775`", "52.78181817`"},
    {"4", "1.6430535`", "49.56353861`"},
    {"75", "1.6311665`", "16.86993474`"},
    {"74", "1.615018125`", "11.75274205`"},
    {"73", "1.42762625`", "8.142504092`"},
    {"69", "1.3645725`", "8.025519366`"},
    {"70", "1.258452625`", "5.91614315`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_4mm_20unitcell\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"58", "1.93299625`", "158.6905461`"},
    {"59", "1.9221045`", "205.8830389`"},
    {"61", "1.901173625`", "220.7277657`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-20 UQ31_stress_28cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"47", "2.95506006`", "107.906`"},
    {"46", "2.9395482`", "117.637`"},
    {"48", "2.925812815`", "133.1035`"},
    {"49", "2.9168933949999998`", "130.284`"},
    {"50", "2.90354555`", "113.773`"},
    {"54", "2.8920820799999998`", "102.378`"},
    {"52", "2.885364865`", "157.119`"},
    {"53", "2.872526525`", "153.9105`"},
    {"56", "2.8453423449999997`", "57.5935`"},
    {"58", "2.83470371`", "16.289`"},
    {"59", "2.8125699033333333`", "173.90433333333334`"},
    {"61", "2.81152553`", "209.228`"},
    {"60", "2.79507007`", "33.6465`"},
    {"63", "2.75808509`", "81.55499999999999`"},
    {"64", "2.75797898`", "192.846`"},
    {"65", "2.74465566`", "72.00450000000001`"},
    {"66", "2.7386656666666664`", "197.42566666666667`"},
    {"68", "2.7291341350000002`", "242.759`"},
    {"67", "2.714378713333333`", "224.96699999999998`"},
    {"70", "2.6662027000000004`", "109.8155`"},
    {"71", "2.6593753749999998`", "166.805`"},
    {"72", "2.642062165`", "40.32`"},
    {"75", "2.6255134625`", "131.68599999999998`"},
    {"75", "2.62417618`", "153.116`"},
    {"73", "2.62362229`", "131.04799999999997`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-19 UQ31_stress_30cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"41", "3.19167528`", "46.963`"},
    {"48", "3.132492495`", "88.0455`"},
    {"49", "3.12567718`", "82.641`"},
    {"50", "3.119064065`", "156.2905`"},
    {"54", "3.097748795`", "149.2`"},
    {"53", "3.082823725`", "104.5655`"},
    {"58", "3.06211712`", "56.309`"},
    {"59", "3.02271351`", "140.037`"},
    {"62", "2.983366365`", "162.38150000000002`"},
    {"64", "2.96847514`", "167.159`"},
    {"65", "2.9588948950000002`", "105.29750000000001`"},
    {"68", "2.9452892950000003`", "127.85849999999999`"},
    {"66", "2.940605605`", "187.83100000000002`"},
    {"67", "2.9246019333333333`", "244.71633333333335`"},
    {"70", "2.8852762800000002`", "143.15699999999998`"},
    {"71", "2.8794194199999996`", "167.227`"},
    {"72", "2.86297147`", "20.593`"},
    {"73", "2.84071572`", "81.78`"},
    {"75", "2.83377278`", "60.776`"},
    {"74", "2.81427628`", "58.893`"},
    {"76", "2.78798719`", "51.861`"},
    {"4", "2.70206306`", "154.316`"},
    {"5", "2.697743245`", "96.1015`"},
    {"6", "2.6822452500000002`", "143.92899999999997`"},
    {"7", "2.66299099`", "137.0805`"},
    {"8", "2.64802703`", "78.855`"},
    {"9", "2.6443683700000005`", "140.9262`"},
    {"10", "2.62908709`", "35.705`"},
    {"11", "2.623992495`", "89.255`"},
    {"12", "2.61412813`", "26.665`"},
    {"15", "2.57518118`", "10.627`"},
    {"17", "2.56037037`", "6.676`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.7174276236215415`*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-05 UQ31_stress_34cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"62", "3.39784094`", "128.161`"},
    {"63", "3.3812811`", "198.286`"},
    {"68", "3.364434684`", "216.56080000000003`"},
    {"69", "3.314629405`", "215.45850000000002`"},
    {"71", "3.30655253`", "117.847`"},
    {"72", "3.2970987666666667`", "192.77666666666664`"},
    {"70", "3.2946932333333327`", "161.17`"},
    {"75", "3.282605055`", "137.4735`"},
    {"73", "3.2645885933333334`", "171.45066666666665`"},
    {"74", "3.2568892853846156`", "319.6094615384615`"},
    {"76", "3.228665935`", "249.8905`"},
    {"1", "3.076583295`", "124.92349999999999`"},
    {"3", "3.058498505`", "110.4695`"},
    {"4", "3.05015508`", "19.388`"},
    {"5", "3.046019179999999`", "123.99000000000001`"},
    {"6", "3.033215615`", "151.678`"},
    {"7", "3.0037578849999997`", "66.517`"},
    {"9", "3.0009795`", "113.862`"},
    {"8", "2.982107055`", "86.3205`"},
    {"11", "2.95435618`", "72.722`"},
    {"13", "2.9478142849999998`", "56.31999999999999`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-09-08 UQ31_stress_36cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"41", "3.79635128`", "15.127`"},
    {"42", "3.79228005`", "12.67`"},
    {"45", "3.76983164`", "50.014`"},
    {"47", "3.76464634`", "36.299`"},
    {"54", "3.7025227249999997`", "114.17349999999999`"},
    {"61", "3.6259140199999997`", "65.49549999999999`"},
    {"59", "3.6156612074999996`", "193.08125`"},
    {"60", "3.6022071999999996`", "132.2843333333333`"},
    {"68", "3.54816817`", "8.532`"},
    {"66", "3.51609093`", "108.61366666666666`"},
    {"67", "3.5050988`", "20.375`"},
    {"72", "3.46792936`", "84.407`"},
    {"70", "3.465488885`", "192.796`"},
    {"75", "3.4617742466666668`", "183.41933333333333`"},
    {"73", "3.4318809`", "86.962`"},
    {"76", "3.40305739`", "179.72899999999998`"},
    {"1", "3.23110771`", "102.71549999999999`"},
    {"3", "3.2050262800000002`", "116.10050000000001`"},
    {"5", "3.19423747`", "97.07650000000001`"},
    {"4", "3.19310232`", "109.304`"},
    {"6", "3.17995673`", "41.625`"},
    {"11", "3.0930036`", "23.769`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData[
 StyleBox["\<\"Measurement folder name: 2017-10-10 UQ35_stress_59cell_4mm\"\>",
  StripOnInput->False,
  FontSize->14,
  FontWeight->Bold]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData[
 TagBox[GridBox[{
    {"21", "5.725136065`", "48.9705`"},
    {"33", "5.581348176666666`", "66.91933333333333`"},
    {"32", "5.57423712`", "47.2055`"},
    {"34", "5.518743883333333`", "66.31733333333332`"},
    {"31", "5.506424715`", "58.0965`"},
    {"38", "5.49751791`", "53.919`"},
    {"44", "5.436610549999999`", "70.247`"},
    {"42", "5.4362409`", "105.23533333333332`"},
    {"50", "5.42640628`", "98.11175`"},
    {"45", "5.36065438`", "89.37`"},
    {"48", "5.36033267`", "5.11`"}
   },
   GridBoxAlignment->{
    "Columns" -> {{Left}}, "ColumnsIndexed" -> {}, "Rows" -> {{Baseline}}, 
     "RowsIndexed" -> {}},
   GridBoxSpacings->{"Columns" -> {
       Offset[0.27999999999999997`], {
        Offset[2.0999999999999996`]}, 
       Offset[0.27999999999999997`]}, "ColumnsIndexed" -> {}, "Rows" -> {
       Offset[0.2], {
        Offset[0.4]}, 
       Offset[0.2]}, "RowsIndexed" -> {}}],
  Function[BoxForm`e$, 
   TableForm[BoxForm`e$]]]], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}],

Cell[BoxData["\<\"\\n\"\>"], "Print",
 CellChangeTimes->{3.7138432122450876`*^9, 3.7138572665282526`*^9, 
  3.714992541838648*^9, 3.7149925819479914`*^9, 3.7149926153429737`*^9, 
  3.7174273103153315`*^9, 3.717427623637165*^9}]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
},
WindowSize->{1218, 657},
WindowMargins->{{65, Automatic}, {Automatic, 27}},
FrontEndVersion->"11.0 for Microsoft Windows (64-bit) (July 28, 2016)",
StyleDefinitions->"Default.nb"
]
(* End of Notebook Content *)

(* Internal cache information *)
(*CellTagsOutline
CellTagsIndex->{}
*)
(*CellTagsIndex
CellTagsIndex->{}
*)
(*NotebookFileOutline
Notebook[{
Cell[CellGroupData[{
Cell[580, 22, 95, 1, 70, "Section"],
Cell[678, 25, 132, 2, 30, "Input"],
Cell[CellGroupData[{
Cell[835, 31, 333, 6, 30, "Input"],
Cell[1171, 39, 317, 5, 30, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[1537, 50, 98, 1, 70, "Section"],
Cell[1638, 53, 487, 12, 30, "Input"],
Cell[2128, 67, 3695, 90, 231, "Input"],
Cell[5826, 159, 2686, 67, 183, "Input"],
Cell[8515, 228, 2371, 62, 107, "Input"]
}, Closed]],
Cell[CellGroupData[{
Cell[10923, 295, 104, 1, 56, "Section"],
Cell[CellGroupData[{
Cell[11052, 300, 150, 2, 49, "Subsection"],
Cell[11205, 304, 246, 6, 30, "Input"],
Cell[11454, 312, 563, 15, 30, "Input"],
Cell[12020, 329, 3917, 89, 582, "Input"],
Cell[15940, 420, 2274, 56, 126, "Input"]
}, Open  ]],
Cell[CellGroupData[{
Cell[18251, 481, 206, 3, 49, "Subsection"],
Cell[CellGroupData[{
Cell[18482, 488, 1036, 25, 126, "Input"],
Cell[CellGroupData[{
Cell[19543, 517, 409, 8, 25, "Print"],
Cell[19955, 527, 1823, 43, 380, "Print"],
Cell[21781, 572, 285, 4, 41, "Print"],
Cell[22069, 578, 408, 8, 25, "Print"],
Cell[22480, 588, 1656, 39, 320, "Print"],
Cell[24139, 629, 285, 4, 41, "Print"],
Cell[24427, 635, 406, 8, 25, "Print"],
Cell[24836, 645, 1717, 42, 365, "Print"],
Cell[26556, 689, 283, 4, 41, "Print"],
Cell[26842, 695, 411, 8, 25, "Print"],
Cell[27256, 705, 4141, 84, 972, "Print"],
Cell[31400, 791, 283, 4, 41, "Print"],
Cell[31686, 797, 411, 8, 25, "Print"],
Cell[32100, 807, 4642, 94, 1123, "Print"],
Cell[36745, 903, 283, 4, 41, "Print"],
Cell[37031, 909, 409, 8, 25, "Print"],
Cell[37443, 919, 4467, 89, 1010, "Print"],
Cell[41913, 1010, 285, 4, 41, "Print"],
Cell[42201, 1016, 411, 8, 25, "Print"],
Cell[42615, 1026, 4068, 81, 929, "Print"],
Cell[46686, 1109, 285, 4, 41, "Print"],
Cell[46974, 1115, 411, 8, 25, "Print"],
Cell[47388, 1125, 2674, 56, 537, "Print"],
Cell[50065, 1183, 283, 4, 41, "Print"]
}, Open  ]]
}, Open  ]]
}, Closed]],
Cell[CellGroupData[{
Cell[50409, 1194, 163, 2, 41, "Subsection"],
Cell[50575, 1198, 1710, 40, 69, "Input"],
Cell[52288, 1240, 1680, 42, 88, "Input"],
Cell[53971, 1284, 3464, 106, 164, "Input"],
Cell[CellGroupData[{
Cell[57460, 1394, 1218, 29, 55, "Input"],
Cell[58681, 1425, 42322, 862, 287, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[101040, 2292, 1180, 31, 77, "Input"],
Cell[102223, 2325, 25534, 521, 291, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[127794, 2851, 2209, 58, 77, "Input"],
Cell[130006, 2911, 16136, 321, 284, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[146179, 3237, 1188, 32, 69, "Input",
 CellID->11232736],
Cell[147370, 3271, 393, 8, 21, "Message"],
Cell[147766, 3281, 391, 8, 21, "Message"]
}, Open  ]],
Cell[CellGroupData[{
Cell[148194, 3294, 1972, 51, 77, "Input"],
Cell[150169, 3347, 9605, 196, 304, "Output"]
}, Open  ]],
Cell[CellGroupData[{
Cell[159811, 3548, 2600, 72, 171, "Input"],
Cell[162414, 3622, 15101, 302, 286, "Output"]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[177564, 3930, 104, 1, 49, "Subsection"],
Cell[CellGroupData[{
Cell[177693, 3935, 2483, 56, 220, "Input"],
Cell[CellGroupData[{
Cell[180201, 3995, 400, 8, 25, "Print"],
Cell[180604, 4005, 13919, 287, 261, "Print"],
Cell[194526, 4294, 274, 4, 41, "Print"],
Cell[194803, 4300, 397, 8, 25, "Print"],
Cell[195203, 4310, 14107, 286, 265, "Print"],
Cell[209313, 4598, 276, 4, 41, "Print"],
Cell[209592, 4604, 399, 8, 25, "Print"],
Cell[209994, 4614, 13086, 270, 265, "Print"],
Cell[223083, 4886, 276, 4, 41, "Print"],
Cell[223362, 4892, 402, 8, 25, "Print"],
Cell[223767, 4902, 14687, 299, 265, "Print"],
Cell[238457, 5203, 274, 4, 41, "Print"],
Cell[238734, 5209, 400, 8, 25, "Print"],
Cell[239137, 5219, 14899, 305, 264, "Print"],
Cell[254039, 5526, 276, 4, 41, "Print"],
Cell[254318, 5532, 402, 8, 25, "Print"],
Cell[254723, 5542, 14603, 298, 265, "Print"],
Cell[269329, 5842, 276, 4, 41, "Print"],
Cell[269608, 5848, 402, 8, 25, "Print"],
Cell[270013, 5858, 14340, 294, 265, "Print"],
Cell[284356, 6154, 274, 4, 41, "Print"],
Cell[284633, 6160, 400, 8, 25, "Print"],
Cell[285036, 6170, 13916, 285, 265, "Print"],
Cell[298955, 6457, 274, 4, 41, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]],
Cell[CellGroupData[{
Cell[299290, 6468, 211, 3, 49, "Subsection"],
Cell[CellGroupData[{
Cell[299526, 6475, 859, 23, 126, "Input"],
Cell[CellGroupData[{
Cell[300410, 6502, 355, 7, 25, "Print"],
Cell[300768, 6511, 1598, 38, 320, "Print"],
Cell[302369, 6551, 229, 3, 41, "Print"],
Cell[302601, 6556, 352, 7, 25, "Print"],
Cell[302956, 6565, 1372, 33, 245, "Print"],
Cell[304331, 6600, 229, 3, 41, "Print"],
Cell[304563, 6605, 352, 7, 25, "Print"],
Cell[304918, 6614, 822, 20, 50, "Print"],
Cell[305743, 6636, 229, 3, 41, "Print"],
Cell[305975, 6641, 355, 7, 25, "Print"],
Cell[306333, 6650, 1819, 42, 380, "Print"],
Cell[308155, 6694, 229, 3, 41, "Print"],
Cell[308387, 6699, 355, 7, 25, "Print"],
Cell[308745, 6708, 2062, 49, 485, "Print"],
Cell[310810, 6759, 227, 3, 41, "Print"],
Cell[311040, 6764, 353, 7, 25, "Print"],
Cell[311396, 6773, 1648, 38, 320, "Print"],
Cell[313047, 6813, 227, 3, 41, "Print"],
Cell[313277, 6818, 353, 7, 25, "Print"],
Cell[313633, 6827, 1676, 39, 335, "Print"],
Cell[315312, 6868, 227, 3, 41, "Print"],
Cell[315542, 6873, 353, 7, 25, "Print"],
Cell[315898, 6882, 1167, 28, 170, "Print"],
Cell[317068, 6912, 227, 3, 41, "Print"]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}, Open  ]]
}
]
*)

